/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2020 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : Thibaut Andrieu (Jan 2011)
**=======================================================================*/

#include <Inventor/nodes/SoOrthographicCamera.h>
#include <Inventor/nodes/SoPerspectiveCamera.h>
#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <DialogViz/SoDialogVizAll.h>
#include <Inventor/actions/SoSearchPathAction.h>
#include <VolumeViz/nodes/SoVolumeRendering.h>
#include <Inventor/actions/SoHandleEventAction.h>
#include <Inventor/nodes/SoSwitch.h>
#include <Inventor/elements/SoViewVolumeElement.h>
#include <Inventor/engines/SoCalculator.h>
#include <Inventor/nodes/SoShape.h>
#include <Inventor/nodes/SoShapeHints.h>

#include <Inventor/misc/SbExtrusionGenerator.h>
#include <Inventor/drawers/SoLassoScreenDrawer.h>
#include <Inventor/drawers/SoEllipseScreenDrawer.h>
#include <Inventor/drawers/SoPolygonScreenDrawer.h>
#include <Inventor/drawers/SoRectangleScreenDrawer.h>
#include <Inventor/actions/SoGetMatrixAction.h>

#include <SoCustomPointScreenDrawer.h>
#include <SoCustomRectangleScreenDrawer.h>
#include <utils.h>


#define DEFAULT_SCENE "$OIVHOME/examples/source/Inventor/Features/CustomScreenDrawer/simpleScene.iv"

// This function will be called each time a line created by the line drawer will be finalized.
// It retrieve points of the line, in camera space, current view volume and current model matrix of 
// g_extrusionGenerator and add an extruded shape thanks to g_extrusionGenerator.
void lineFinalizedCallback ( SoPolyLineScreenDrawer::EventArg& eventArg )
{
  std::cout << "Rectangle finalized." << std::endl;
  eventArg.getSource()->clear();
  eventArg.getAction()->setHandled();
}


int
main(int argc, char **argv)
{
  Widget myWindow = SoXt::init(argv[0]); 
  if (myWindow == NULL)
    exit(1);

  SoPreferences::setString("OIV_USER_LIBS", "customScreenDrawerNodes");

  // initialize some classes
  SoDialogViz::init();
  SoCustomPointScreenDrawer::initClass();
  SoCustomRectangleScreenDrawer::initClass();

  SoSeparator* viewerRoot = new SoSeparator;
  viewerRoot->ref();

  SoCamera* camera = new SoPerspectiveCamera;
  viewerRoot->addChild( camera );

  //------------------------------------------------------------------------------
  // load scene

  SbString filename;
  if ( argc == 1 )
    filename = DEFAULT_SCENE;
  else
    filename = SbString(argv[1]);

  SoInput myInput;
  if (! myInput.openFile(filename) ) 
  {
    std::cerr << filename.getString() << std::endl;
    exit(1);
  }

  SoSeparator* root = SoDB::readAll(&myInput);
  if (root == NULL) {
    exit(1);
  }
  viewerRoot->addChild( root );

  SoSwitch* lineDrawerSwitch = find<SoSwitch>(root);

  SoCustomRectangleScreenDrawer* rectangle = find<SoCustomRectangleScreenDrawer>(root);
  rectangle->onFinish.add(lineFinalizedCallback);

  //------------------------------------------------------------------------------
  // Build dialog.

  SoTopLevelDialog* myTop = new SoTopLevelDialog();
  myTop->ref();
  myTop->label =  "SurfaceGen Demo" ;
  myTop->position.setValue(0,0);

  SoDialogCustom* myCustom = new SoDialogCustom;
  myCustom->width = 600;
  myCustom->height = 400;
  myTop->addChild(myCustom);

  SoColumnDialog* guiContainer = new SoColumnDialog();
  guiContainer->fixedHeight = TRUE;
  myTop->addChild(guiContainer);

  // combo box to select lineDrawer
  SoDialogComboBox* modeCombo = new SoDialogComboBox;
  modeCombo->label = "Selection mode ";
  modeCombo->items.set1Value(0, "Rectangle");
  modeCombo->items.set1Value(1, "Point");
  modeCombo->selectedItem = 0;
  modeCombo->fixedWidth = TRUE;
  guiContainer->addChild(modeCombo);
  // connect combobox to lineDrawer switch
  lineDrawerSwitch->whichChild.connectFrom(&modeCombo->selectedItem);

  myTop->buildDialog(myWindow, TRUE);
  myTop->show();

  SoXtExaminerViewer* myViewer = new SoXtExaminerViewer(myCustom->getWidget());
  myViewer->setTransparencyType(SoGLRenderAction::OPAQUE_FIRST);
  myViewer->setFastEditSavePolicy(SoGLRenderAction::WHEN_NEEDED);

  myViewer->setSceneGraph(viewerRoot);
  viewerRoot->unref();
  myViewer->setCamera( camera );

  myViewer->viewAll() ;
  myViewer->show();

  SoXt::show(myWindow);
  SoXt::mainLoop();

  myTop->unref();
  delete myViewer;

  SoCustomRectangleScreenDrawer::initClass();
  SoCustomPointScreenDrawer::initClass();
  SoDialogViz::finish();
  SoXt::finish();

  return 0;
}


