/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2020 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : Tristan Mehamli (Nov 2009)
**=======================================================================*/
#ifdef WIN32
#  include <winsock2.h>
#  pragma comment(lib, "Ws2_32.lib")
#else // Linux
#  include <unistd.h>
#endif // WIN23

#include <Inventor/SoDB.h>
#include <Inventor/devices/SoDevice.h>
#include <Inventor/devices/SoCpuDevice.h>
#include <Inventor/devices/SoGLDevice.h>

#include <Inventor/SbString.h>
#include <Inventor/STL/fstream>
#include <Inventor/STL/iostream>
#include <Inventor/STL/string>

// Uncomment this line to save output to <hostname>.txt file
//#define FILE_OUTPUT

char host[1024];


// Get local host name
void getHostname()
{
#if defined (_WIN32)
  WSADATA WSAData;
  WSAStartup( MAKEWORD(2, 2), &WSAData );
  gethostname( host, 1024 );
  WSACleanup();
#else // UNIX
  gethostname( host, 1024 );
#endif // WIN32
}

int main( int /*argc*/, char** /*argv*/ )
{
  // Init Inventor core for CPU and GL devices support
  SoDB::init();

#ifdef FILE_OUTPUT
  getHostname();
  std::string filename = host;
  filename += ".txt";
  std::ofstream file ( filename.c_str() );
#define OUTPUT_STREAM file
#else
#define OUTPUT_STREAM std::cout
#endif

  // get the number of Open Inventor detected devices
  int nbDevices = SoDevice::getDevicesCount();

  // write global infos.
  OUTPUT_STREAM << "Platform: " << SoDevice::getOSName().toLatin1() << std::endl;
  OUTPUT_STREAM << std::endl;
  OUTPUT_STREAM << "Number of registered devices: " << nbDevices << std::endl;
  OUTPUT_STREAM << std::endl;

  // loop over devices to print their particular information
  for ( int i = 0; i < nbDevices; i++ )
  {
    SoDevice* dev = SoDevice::getDevice( i );
    if ( dev )
    {
      SoCpuDevice* cpu = dynamic_cast<SoCpuDevice*>(dev);
      SoGLDevice* gpu = dynamic_cast<SoGLDevice*>(dev);
      if ( cpu )
      {
        OUTPUT_STREAM << "--CPU Devices--" << std::endl;
        OUTPUT_STREAM << *cpu << std::endl;
      }
      else if ( gpu )
      {
        OUTPUT_STREAM << "--OpenGL Devices--" << std::endl;
        OUTPUT_STREAM << *gpu << std::endl;
      }
    }
    else
      std::cerr << "Bad device index" << std::endl;

    OUTPUT_STREAM << std::endl;
  }

  SoDB::finish();

  return 0;
}


