/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2020 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : Rodolphe ALBOU (Nov 2000)
**=======================================================================*/

#include <Inventor/SoDB.h>
#include <Inventor/SoInput.h>
#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/Xt/SoXtFileSelectionDialog.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoWWWInline.h>

#include <Inventor/helpers/SbFileHelper.h>

SoSeparator *scene = NULL;
SoXtFileSelectionDialog *myFileDialog = NULL;
SoXtExaminerViewer *myViewer = NULL;

/**********************************************************************/

SoSeparator *
readFile(const char *filename)
{
  // Open the input file
  SoInput mySceneInput;
  if (!mySceneInput.openFile(filename)) {
    fprintf(stderr, "Cannot open file %s\n", filename);
    return NULL;
  }
  
  // Read the whole file into the database
  SoSeparator *myGraph = SoDB::readAll(&mySceneInput);
  if (myGraph == NULL) {
    fprintf(stderr, "Problem reading file\n");
    return NULL;
  } 
  
  mySceneInput.closeFile();
  return myGraph;
}

void 
AcceptCB(void* /*data*/, SoXtFileSelectionDialog *dialog)
{
  scene = readFile(dialog->getFilePath());
  delete myFileDialog;
  myViewer->setSceneGraph(scene);
}

void 
AbortCB(void* /*data*/, SoXtFileSelectionDialog* /*dialog*/)
{
   scene = readFile("$OIVHOME/examples/data/Inventor/bookshelf.iv");
  delete myFileDialog;
  myViewer->setSceneGraph(scene);
}

int
main(int /*argc*/, char **argv)
{
  // Initialize Inventor and Xt
  Widget myWindow = SoXt::init(argv[0]);
  SoWWWInline::setReadAsSoFile(TRUE);
  // Create a viewer
  myViewer = new SoXtExaminerViewer(myWindow);
  
  myFileDialog = new SoXtFileSelectionDialog();
  myFileDialog->setFileDirectory((char*)"$OIVHOME/examples/data/Inventor/");
  myFileDialog->setTitle((char*)"Select an Inventor file");
#ifdef _WIN32
  myFileDialog->setFilter("iv", "Inventor files (*.iv)");
#else
  myFileDialog->setFilter((char*)"iv", NULL);
#endif
  myFileDialog->setAcceptCallback(AcceptCB,NULL);
  myFileDialog->setAbortCallback(AbortCB,NULL);
  myFileDialog->setMode(SoXtFileSelectionDialog::OPEN_FILE);
  myFileDialog->show();
  
  // attach and show viewer
  myViewer->setTitle("File Reader");
  myViewer->show();
  
  // Loop forever
  SoXt::show(myWindow);
  SoXt::mainLoop();
  
  delete myViewer;
  SoXt::finish();

  return 0;
}


