/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2020 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
/*--------------------------------------------------------------
 *  This example shows how to use graphic configuration.
 *------------------------------------------------------------*/

#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/nodes/SoBaseColor.h>
#include <Inventor/nodes/SoCone.h>
#include <Inventor/nodes/SoFont.h>
#include <Inventor/nodes/SoLightModel.h>
#include <Inventor/nodes/SoOrthographicCamera.h>
#include <Inventor/nodes/SoPerspectiveCamera.h>
#include <Inventor/nodes/SoPickStyle.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoSwitch.h>
#include <Inventor/nodes/SoText2.h>
#include <Inventor/nodes/SoTranslation.h>

#include <Inventor/components/SoGLGraphicConfigTemplate.h>
#include <Inventor/components/SoGLGraphicDevice.h>
#include <Inventor/components/SoGraphicConfig.h>
#if defined(_WIN32) || defined(_WIN64)
#include <Inventor/components/SoWinGLGraphicConfig.h>
#else
#include <Inventor/components/SoXtGLGraphicConfig.h>
#endif

SoSwitch *displayInfo(SoText2 *InfoText);
SoText2 *describeGraphicConfig(SoGLGraphicConfig *gc);
SoXtExaminerViewer * myViewer;

int
main(int argc, char **argv)
{
  // Initialize Inventor and Xt
  Widget myWindow = SoXt::init(argv[0]);
  if (myWindow == NULL) exit(1);

  SoSeparator *root = new SoSeparator;
  root->ref();

  root->addChild(new SoPerspectiveCamera);

  // Open an inventor file
  SoInput myInput;
  SbBool result = FALSE;

  if (argc > 1) {
    result = myInput.openFile(argv[1]);
  }
  if (!result) {
    result = myInput.openFile("$OIVHOME/examples/data/Inventor/gear.iv");
  }
  SoSeparator *geomObject;
  if (result) {
    geomObject = SoDB::readAll(&myInput);
  }
  root->addChild((result && geomObject) ? geomObject : (SoNode *)(new SoCone));

  SoGLGraphicConfigTemplate *gTemplate = new SoGLGraphicConfigTemplate;
  gTemplate->setDoubleBuffer(SoGraphicConfigTemplate::REQUIRED);
  gTemplate->setStereoBuffer(SoGraphicConfigTemplate::PREFERRED);
  gTemplate->setAccelerated(SoGraphicConfigTemplate::REQUIRED);
  gTemplate->setFullSceneAntialiasing(SoGraphicConfigTemplate::REQUIRED, 0, 4);

  // Viewer
  myViewer = new SoXtExaminerViewer(myWindow);
  myViewer->setSceneGraph(root);
  myViewer->viewAll();
  myViewer->show();


  // Choose graphic configuration
#ifdef _WIN32
  HWND hDeskWnd = GetDesktopWindow();
  if (hDeskWnd == NULL) {
    return -1;
  }
  HDC hDeskDC = GetDC(hDeskWnd);
  if (hDeskDC == NULL) {
    return -1;
  }
  SoGLGraphicDevice dev(hDeskDC);
#else
  Display *display = XtDisplay(myWindow);//XOpenDisplay(NULL);
  SoGLGraphicDevice dev(display);
#endif

  // Show the application
  SoXt::show(myWindow);
  myViewer->setGraphicConfigTemplate(gTemplate);

  SoGLGraphicConfigTemplate* gcTemplate = myViewer->getGraphicConfigTemplate();

// Display all the graphic configuration records and the current one
  size_t listSize = dev.getNum(*gcTemplate);
  for (size_t n = 0; n < listSize; n++) {
    SoGraphicConfig *gcPtr = (SoGraphicConfig *)dev.getGraphicConfig(*gcTemplate, n);
    gcPtr->printInfo();
    printf("\n");
  }

  SoGLGraphicConfig *gc = (SoGLGraphicConfig *)dev.getBestGraphicConfig(*gcTemplate);
  root->addChild(displayInfo(describeGraphicConfig(gc)));

  SoXt::mainLoop();

  root->unref();
  delete gTemplate;
  delete myViewer;
  SoXt::finish();

  return 0;
}

// Display the chosen graphic configuration info
SoText2 *
describeGraphicConfig(SoGLGraphicConfig *gc)
{
  SoText2 *infoText = new SoText2;

  if (gc) {
    char buffer[200];
    int line = 0, bits, redBits, greenBits, blueBits, alphaBits;

    sprintf(buffer, "Graphic configuration :");
    infoText->string.set1Value(line++, buffer);
    sprintf(buffer, "DOUBLEBUFFER : %s", (gc->isDoubleBuffer() ? "enable" : "disable"));
    infoText->string.set1Value(line++, buffer);
    sprintf(buffer, "RAW STEREO : %s", (gc->isStereoBuffer() ? "enable" : "disable"));
    infoText->string.set1Value(line++, buffer);
    sprintf(buffer, "ACCELERATED : %s", (gc->isAccelerated() ? "enable" : "disable"));
    infoText->string.set1Value(line++, buffer);
    gc->getDepth(bits);
    sprintf(buffer, "DEPTH (Z) : %i", bits);
    infoText->string.set1Value(line++, buffer);
    //sprintf(buffer, "%s", (gc->() ? "enable" : "disable"));
    //infoText->string.set1Value(line++, buffer);
    gc->getRGBAColor(redBits, greenBits, blueBits, alphaBits);
    if ( redBits > 0 )
    {
      sprintf( buffer, "RGBA R/G/B/A : %i/%i/%i/%i",
              redBits, greenBits, blueBits, alphaBits );
      infoText->string.set1Value( line++, buffer );
    }
    else
    {
      sprintf( buffer, "RGBA : %s", "N/A" );
      infoText->string.set1Value( line++, buffer );
    }
    gc->getAccum(redBits, greenBits, blueBits, alphaBits);
    if (redBits > 0) {
        sprintf(buffer, "ACCUM R/G/B/A : %i/%i/%i/%i", 
                redBits, greenBits, blueBits, alphaBits);
        infoText->string.set1Value(line++, buffer);
    }
    else {
      sprintf(buffer, "ACCUM : %s", "N/A");
      infoText->string.set1Value(line++, buffer);
    }
    
    gc->getStencil(bits);
    sprintf(buffer, "STENCIL : %i", bits);
    infoText->string.set1Value(line++, buffer);

    SbBool activ = gc->getFullSceneAntialiasing(bits);
    sprintf(buffer, "FSAA supported : %s", (activ) ? "YES " : "NO");
    SbString str = buffer;
    if (activ) {
      sprintf(buffer, "(%d samples)", bits);
      str += buffer;
    }
    infoText->string.set1Value(line++, str);
  }
  else {
    infoText->string.set1Value(0, "No specified graphic configuration.");
  }

  return infoText;
}

SoSwitch *
displayInfo(SoText2 *InfoText) 
{
  // Informations
  SoSwitch *infoSwitch = new SoSwitch;
  infoSwitch->ref();
  infoSwitch->whichChild = SO_SWITCH_ALL;
  
  SoSeparator *infoSep = new SoSeparator;

  SoOrthographicCamera *cam = new SoOrthographicCamera;
  infoSep->addChild(cam);
  cam->viewportMapping = SoOrthographicCamera::LEAVE_ALONE;
  cam->position.setValue(SbVec3f(0.005f,0.005f,1));
  cam->height = 0.01f;
  
  SoPickStyle *pickStyle = new SoPickStyle;
  pickStyle->style = SoPickStyle::UNPICKABLE;
  infoSep->addChild(pickStyle);
  
  infoSwitch->addChild(infoSep);
  
  SoLightModel *lModel = new SoLightModel;
  lModel->model = SoLightModel::BASE_COLOR;
  infoSep->addChild(lModel);
  
  SoFont *fontInfo = new SoFont;
  fontInfo->name = "Courier New";
  fontInfo->size = 12;
  infoSep->addChild(fontInfo);
  
  SoBaseColor *infoColor = new SoBaseColor;
  infoColor->rgb.setValue(SbColor(1, 1, 0.f));
  infoSep->addChild(infoColor);
  
  SoTranslation *transInfo = new SoTranslation;
  transInfo->translation.setValue(0.00025f, 0.0095f, 0.);
  infoSep->addChild(transInfo);
  
  infoSep->addChild(InfoText);
  
  infoSwitch->unrefNoDelete();
  return infoSwitch;
}

