/*=============================================================================
** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),       **
**              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                **
**                                                                           **
**  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS  **
**  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR  **
**  WRITTEN AUTHORIZATION OF FEI S.A.S.                                      **
**                                                                           **
**                        RESTRICTED RIGHTS LEGEND                           **
**  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS **
**  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN **
**  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT **
**  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN **
**  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.        **
**                                                                           **
**                   COPYRIGHT (C) 1996-2022 BY FEI S.A.S,                   **
**                             MERIGNAC, FRANCE                              **
**                           ALL RIGHTS RESERVED                             **
=============================================================================*/


#include <HighLightWidget.h>
#include <Inventor/Qt/SbQtHelper.h>
#include <Inventor/SoDB.h>
#include <Inventor/SoInteraction.h>
#include <Inventor/ViewerComponents/Qt/RenderAreaOrbiter.h>
#include <Inventor/ViewerComponents/nodes/SoViewingCube.h>
#include <Inventor/actions/SoHaloHighlightRenderAction.h>
#include <Inventor/helpers/SbFileHelper.h>
#include <Inventor/nodes/SoFile.h>
#include <Inventor/nodes/SoSelection.h>
#include <QApplication>
#include <QBoxLayout>
#include <QDebug>
#include <QFileDialog>
#include <QMainWindow>
#include <QMenuBar>

int
main( int argc, char** argv )
{
  SbQtHelper::addPlatformPluginsPath();

  QApplication app( argc, argv );

  SoDB::init();
  SoInteraction::init();


  // GUI
  QMainWindow* mainWindow = new QMainWindow;

  QMenuBar* menuBar = new QMenuBar;
  QAction* openModelAction = menuBar->addMenu( "File" )->addAction( "Open" );
  mainWindow->setMenuBar( menuBar );

  QWidget* centralWidget = new QWidget( mainWindow );
  centralWidget->setLayout( new QVBoxLayout );
  centralWidget->layout()->setContentsMargins( 0, 0, 0, 0 );
  centralWidget->layout()->setSpacing( 0 );

  HighLightWidget* highlightWidget = new HighLightWidget( mainWindow );
  centralWidget->layout()->addWidget( highlightWidget );

  RenderAreaOrbiter* renderArea = new RenderAreaOrbiter( mainWindow );
  const float grayVal = 0.92f;
  renderArea->setClearColor( SbColorRGBA( grayVal, grayVal, grayVal, 1.0f ) );
  SoGLRenderAction* glrenderAction = highlightWidget->createAction();
  renderArea->setGLRenderAction( glrenderAction );
  renderArea->setAntialiasingMode( SoSceneManager::AUTO );
  renderArea->setAntialiasingQuality( 1 );
  centralWidget->layout()->addWidget( renderArea->getContainerWidget() );

  mainWindow->setCentralWidget( centralWidget );


  // Scene graph
  SoRef<SoSelection> root = new SoSelection;
  SoFile* modelFile = new SoFile;
  modelFile->name = "$OIVHOME/examples/data/Inventor/Models/harley_y_vertical.iv";
  root->addChild( modelFile );

  // ViewingCube custom
  SoViewingCube* vCube = renderArea->getSceneInteractor()->getViewingCube();
  vCube->facePosX = "$OIVHOME/examples/data/Inventor/ViewingCube/Faces/xyz/xpos.png";
  vCube->faceNegX = "$OIVHOME/examples/data/Inventor/ViewingCube/Faces/xyz/xneg.png";
  vCube->facePosY = "$OIVHOME/examples/data/Inventor/ViewingCube/Faces/xyz/ypos.png";
  vCube->faceNegY = "$OIVHOME/examples/data/Inventor/ViewingCube/Faces/xyz/yneg.png";
  vCube->facePosZ = "$OIVHOME/examples/data/Inventor/ViewingCube/Faces/xyz/zpos.png";
  vCube->faceNegZ = "$OIVHOME/examples/data/Inventor/ViewingCube/Faces/xyz/zneg.png";
  vCube->edgeSize = 0.3f;
  vCube->edgeStyle = SoViewingCube::EdgeStyle::FLAT;

  renderArea->setSceneGraph( root.ptr() );
  renderArea->viewAll( SbViewportRegion() );

  mainWindow->resize( 1600, 900 );
  mainWindow->show();


  // Redraw scene on selection changed
  root->addStartCallback( []( void* /*data*/, SoSelection* selection ) {
    selection->touch();
  } );


  // GUI Connections
  QObject::connect( openModelAction, &QAction::triggered, [&]() {
    QString fileName = QFileDialog::getOpenFileName( mainWindow,
                                                     "Open File",
                                                     QString::fromStdWString( SbFileHelper::expandString( "$OIVHOME/data/models" ).toStdWString() ),
                                                     "Models (*.iv)" );
    if ( fileName.size() )
    {
      modelFile->name.setValue( fileName.toStdWString().c_str() );
      root->deselectAll();
      renderArea->viewAll( SbViewportRegion() );
    }
  } );

  QObject::connect( highlightWidget, &HighLightWidget::modified, [&]() mutable {
    SoGLRenderAction* curAction = renderArea->getGLRenderAction();
    SoGLRenderAction* newAction = highlightWidget->createAction(curAction);
    if (newAction != curAction)
    {
      renderArea->setGLRenderAction(newAction);
      delete glrenderAction;
      glrenderAction = newAction;
    }
    modelFile->touch(); // Refresh
  } );


  int retVal = app.exec();

  // We free the memory.
  root = NULL; // call before SoDB::finish();
  delete glrenderAction;
  delete mainWindow;
  SoInteraction::finish();
  SoDB::finish();

  return retVal;
}
