/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2020 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/

#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>

#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoImage.h>

#include <Inventor/nodes/SoText2.h>
#include <Inventor/nodes/SoFont.h>
#include <Inventor/nodes/SoMaterial.h>
#include <Inventor/helpers/SbFileHelper.h>

SoImage *Image;

#include <DialogViz/SoDialogVizAll.h>

class HorizontalAlignAuditor : public SoDialogChoiceAuditor
{
public:
  void dialogChoice( SoDialogChoice* cpt )
  {
    Image->horAlignment = cpt->selectedItem.getValue();
  }
};

class VerticalAlignAuditor : public SoDialogChoiceAuditor
{
public:
  void dialogChoice( SoDialogChoice* cpt )
  {
    Image->vertAlignment = cpt->selectedItem.getValue();
  }
};

class WidthSliderAuditor : public SoDialogIntegerSliderAuditor
{
public:
  void dialogIntegerSlider( SoDialogIntegerSlider* cpt )
  {
    Image->width = cpt->value.getValue();
  }
};

class HeightSliderAuditor : public SoDialogIntegerSliderAuditor
{
public:
  void dialogIntegerSlider( SoDialogIntegerSlider* cpt )
  {
    Image->height = cpt->value.getValue();
  }
};

class QuitButtonAuditor : public SoDialogPushButtonAuditor
{
public:
  void dialogPushButton( SoDialogPushButton* /*cpt*/ )
  {
    exit(0);
  }
};

static void
buildDialog( SoTopLevelDialog* dialog, Widget rootWidget)
{
  dialog->label.setValue( "Options" );

  #define NUM_HOR_ALIGNS 3
  static const char* horAligns[NUM_HOR_ALIGNS] = {
    "LEFT", 
    "CENTER", 
    "RIGHT"
  };
  SoDialogComboBox* horAlign = new SoDialogComboBox;
  horAlign->label.setValue( "Hor. align.  :" );
  horAlign->items.setValues( 0, NUM_HOR_ALIGNS, horAligns );
  horAlign->addAuditor( new HorizontalAlignAuditor );
  dialog->addChild( horAlign );

  #define NUM_VERT_ALIGNS 3
  static const char* vertAligns[NUM_VERT_ALIGNS] = {
    "BOTTOM", 
    "HALF", 
    "TOP"
  };
  SoDialogComboBox* vertAlign = new SoDialogComboBox;
  vertAlign->label.setValue( "Vert. align. :" );
  vertAlign->items.setValues( 0, NUM_VERT_ALIGNS, vertAligns );
  vertAlign->addAuditor( new VerticalAlignAuditor );
  dialog->addChild( vertAlign );

  SbVec2s size;
  int nc;
  Image->image.getValue(size, nc);

  SoDialogIntegerSlider* widthSlider = new SoDialogIntegerSlider;
  widthSlider->label.setValue( "Width :" );
  widthSlider->min.setValue( 1 );
  widthSlider->max.setValue( 800 );
  widthSlider->value.setValue( size[0] );
  widthSlider->addAuditor( new WidthSliderAuditor );
  dialog->addChild( widthSlider );

  SoDialogIntegerSlider* heightSlider = new SoDialogIntegerSlider;
  heightSlider->label.setValue( "Height :" );
  heightSlider->min.setValue( 1 );
  heightSlider->max.setValue( 800 );
  heightSlider->value.setValue( size[1] );
  heightSlider->addAuditor( new HeightSliderAuditor );
  dialog->addChild( heightSlider );

  SoDialogPushButton* quitButton = new SoDialogPushButton;
  quitButton->buttonLabel.setValue( "Quit" );
  quitButton->addAuditor( new QuitButtonAuditor );
  dialog->addChild( quitButton );

  dialog->buildDialog( rootWidget );
}

int
main(int, char **argv)
{
  // Initialize Inventor and Xt
  Widget myWindow = SoXt::init(argv[0]);

  SoDialogViz::init();

  SoSeparator *root = new SoSeparator;

  // Create the image node using the file "./sillyFace.rgb" as source.
  Image = new SoImage;
  SbString ImagePath = SbFileHelper::expandString ("$OIVHOME/examples/source/Inventor/Features/Image/sillyFace.rgb");
  Image->filename = ImagePath;

  SoText2 *text2 = new SoText2;
  text2->justification = SoText2::CENTER;
  text2->string = "0";

  SoMaterial *mat = new SoMaterial;
  mat->diffuseColor.setValue(1, 0, 0);   

  SoFont *font = new SoFont;
  font->size.setValue(10.);

  root->ref();
  root->addChild(mat);
  root->addChild(font);
  root->addChild(text2);
  root->addChild(Image);

  SoRef<SoTopLevelDialog> dialog = new SoTopLevelDialog;
  buildDialog( dialog.ptr(), myWindow );
  dialog->show();

  // Create a viewer
  SoXtExaminerViewer *myViewer = new SoXtExaminerViewer(myWindow);

  // attach and show viewer
  myViewer->setSceneGraph(root);
  myViewer->viewAll();
  myViewer->setTitle("Image");
  myViewer->show();

  // Loop forever
  SoXt::show(myWindow);
  SoXt::mainLoop();

  dialog = NULL;
  SoDialogViz::finish();

  root->unref();
  delete myViewer;
  SoXt::finish();
  return 0;
}


