/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : SGI (MMM YYYY)
**=======================================================================*/

/*--------------------------------------------------------------
 *  This is an example that uses the SoWWWInline node
 *  It reads the file star.iv 
 *------------------------------------------------------------*/

#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/SoXtRenderArea.h>
#include <Inventor/nodes/SoCone.h>
#include <Inventor/nodes/SoDirectionalLight.h>
#include <Inventor/nodes/SoMaterial.h>
#include <Inventor/nodes/SoPerspectiveCamera.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoWWWInline.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>

#include <Inventor/SoDB.h>
#include <Inventor/SoInput.h>

#include <Inventor/SoWinApp.h>

#include <Inventor/helpers/SbFileHelper.h>

#ifdef _WIN32
#  include "print.h"
#endif

void
myInlineCallback(const SbString &url, void* /*userdata*/, SoWWWInline *node)
{
  // Open the input file
  SoInput mySceneInput;
  if (!mySceneInput.openFile(url.getString())) {
    fprintf(stderr, "Cannot open file %s\n", url.getString());
    return;
  }

  // Read the whole file into the database
  SoSeparator *myGraph = SoDB::readAll(&mySceneInput);
  if (myGraph == NULL) {
    fprintf(stderr, "Problem reading file\n");
    return ;
  } 

  mySceneInput.closeFile();
  node->setChildData(myGraph);
}

int
main(int, char **argv)
{
  // Initialize Inventor. This returns a main window to use.
  // If unsuccessful, exit.
  Widget myWindow = SoXt::init(argv[0]); // pass the app name
  if (myWindow == NULL) 
    exit(1);

  // Make a scene containing a red cone
  SoSeparator *root = new SoSeparator;
  SoPerspectiveCamera *myCamera = new SoPerspectiveCamera;
  SoMaterial *myMaterial = new SoMaterial;
  SoWWWInline *myInline = new SoWWWInline;
  SbColor bcolr;
  root->ref();
  root->addChild(myCamera);
  root->addChild(new SoDirectionalLight);
  myMaterial->diffuseColor.setValue(1.0, 0.0, 0.0);   // Red
  root->addChild(myMaterial);

  // Set up the bounding box size and location
  myInline->bboxCenter.setValue(2.0,-2.0,0.0);
  myInline->bboxSize.setValue(3.0,3.0,3.0);
  myInline->setBoundingBoxVisibility(SoWWWInline::ALWAYS);
  bcolr[0] = 0.0;
  bcolr[1] = 0.0;
  bcolr[2] = 1.0;
  myInline->setBoundingBoxColor(bcolr);

  // Set the name of the file to read in the callback
  SbString InLineFile = SbFileHelper::expandString("$OIVHOME/examples/source/Inventor/Features/InLine/star.iv");
  myInline->name.setValue("star.iv");
  myInline->setFullURLName(InLineFile);
  myInline->setFetchURLCallBack(myInlineCallback, (void *)NULL);
  root->addChild(new SoCone);
  root->addChild(myInline);

  // Create a renderArea in which to see our scene graph.
  // The render area will appear within the main window.
  SoXtRenderArea *myRenderArea = new SoXtRenderArea(myWindow);

  // Make myCamera see everything.
  myCamera->viewAll(root, myRenderArea->getViewportRegion());

  // Put our scene in myRenderArea, change the title
  myRenderArea->setSceneGraph(root);
  myRenderArea->setTitle("Inline");
  myRenderArea->show();

  SoXt::show(myWindow);  // Display main window
  SoXt::mainLoop();      // Main Inventor event loop
  SoXt::finish();

  return 0;
}


