/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2020 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/

#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>

#include <Inventor/actions/SoWriteAction.h>

#include <Inventor/nodes/SoVertexProperty.h>
#include <Inventor/nodes/SoIndexedFaceSet.h>
#include <Inventor/nodes/SoFaceSet.h>
#include <Inventor/nodes/SoSwitch.h>

#include <Inventor/nodes/SoMaterial.h>
#include <Inventor/nodes/SoShapeHints.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoSphere.h>
#include <Inventor/nodes/SoTranslation.h>
#include <Inventor/nodes/SoCube.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoIndexedTexture2.h>
#include <Inventor/nodes/SoColorMap.h>
#include <Inventor/nodes/SoTranslation.h>
#include <DialogViz/SoDialogVizAll.h>
#include <Inventor/actions/SoSearchAction.h> 
#include <Inventor/SoPath.h> 
#include <Inventor/nodes/SoShaderProgram.h>
#include <Inventor/nodes/SoFragmentShader.h>
#include <Inventor/nodes/SoVertexShader.h>
#include <Inventor/nodes/SoShaderParameter.h> 
#include <Inventor/nodes/SoPerspectiveCamera.h> 
#include <Inventor/Xt/SoXtDirectionalLightEditor.h>
#include <Inventor/Xt/SoXtMaterialEditor.h>
#include <Inventor/Xt/SoXtFileSelectionDialog.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/nodes/SoDirectionalLight.h>

#include "auditor.h"
#include <Inventor/STL/vector>

#include <Inventor/helpers/SbFileHelper.h>

#ifndef _WIN32
#include <stddef.h>
#include <stdio.h>
#include <sys/types.h>
#include <dirent.h>
#endif

#define SO_TITLE "Indexed Texture"
#define DEFAULT_FILE_NAME "Syn_64.vol"

extern int ReadVolFile(const SbString&, int &, int &, int &, unsigned char *&);
/*---------------------------------------------------------------------------*/
SoFaceSet *createPlan();
SoIndexedFaceSet *createSinSurface();
SoShaderParameter1f *depthParam;
SoXtDirectionalLightEditor *m_headlightEd;
SoDirectionalLight *m_directionalLight;
SoShaderParameter1f *texSizeParam;
SoXtMaterialEditor *m_mtlEditor;
SoMaterial *m_material;
SoSwitch *shaderSwitch;
SoSwitch *camSwitch;
SoXtExaminerViewer *myViewer;
MyAuditorClass *auditor;
SoCamera *camFix, *camShader;
/*---------------------------------------------------------------------------*/

Widget buildInterface(Widget window, SoColorMap *colorMap, 
                      SoIndexedTexture2 *indexedTexture, SoSwitch *shapeSwitch);

SoShaderProgram *
createShader()
{
  //Shader
  SoShaderProgram *program = new SoShaderProgram;  

  SoVertexShader *vp = new SoVertexShader;  
  vp->sourceProgram.setValue(SbFileHelper::expandString("$OIVHOME/examples/source/Inventor/Features/IndexedTexture/shaders/vert.glsl"));

  SoFragmentShader *fp = new SoFragmentShader;  
  fp->sourceProgram.setValue(SbFileHelper::expandString("$OIVHOME/examples/source/Inventor/Features/IndexedTexture/shaders/frag.glsl"));
  
  texSizeParam = new SoShaderParameter1f;
  texSizeParam->name = "dimTexture";
  texSizeParam->value = 64.0f;

  depthParam = new SoShaderParameter1f;
  SoShaderParameter1i *param = new SoShaderParameter1i;
  depthParam->name = "depth";
  depthParam->value = 1;
  param->value.setValue(0);
  param->name = "indexedTex";
  SoShaderParameter1i *param2 = new SoShaderParameter1i;
  param2->name = "colormap";
  param2->value.setValue(1);
  fp->parameter.set1Value(0, param);
  fp->parameter.set1Value(1, param2);
  fp->parameter.set1Value(2, depthParam);
  fp->parameter.set1Value(3, texSizeParam);

  program->shaderObject.set1Value(0, fp);
  program->shaderObject.set1Value(1, vp);
 
  return program;
}

int
main(int, char **argv)
{
  Widget myWindow = SoXt::init(argv[0]);
  if(myWindow == NULL) exit(1);
  SoDialogViz::init();

  m_headlightEd = new SoXtDirectionalLightEditor();
  m_headlightEd->setTitle( "Light Direction Editor" );	

  SoSeparator *root = new SoSeparator;
  root->ref();

  SoMessageDialog *errorDialog = NULL ;

  if( !SoFragmentShader::isSupported(SoShaderObject::GLSL_PROGRAM) ) 
  {
    errorDialog = new SoMessageDialog ;
    errorDialog->title = "IndexedTexture Warning";
    errorDialog->type = SoMessageDialog::MD_WARNING;
    errorDialog->label = "GLSL is not supported by your graphic board !";
    errorDialog->show() ;
  }

  camSwitch = new SoSwitch;
  camSwitch->whichChild = 1;
  SoGroup *camGroup = new SoGroup;

  SoCamera *camera = new SoPerspectiveCamera;
  camGroup->addChild(camera);
  SoDirectionalLight *light = new SoDirectionalLight;
  camGroup->addChild(light);
  camSwitch->addChild(camGroup);

  SoGroup *camGroupFix = new SoGroup;
  camSwitch->addChild(camGroupFix);  
  camGroupFix->addChild(light);
  camGroupFix->addChild(camera);  

  root->addChild(camSwitch);

  shaderSwitch = new SoSwitch;
  shaderSwitch->whichChild = -1;

  SoGroup *bumpmapSep = new SoGroup;
  shaderSwitch->addChild(bumpmapSep);

  m_material = new SoMaterial;
  m_material->shininess = 0.9f; 
  m_material->specularColor = SbVec3f(0.1f, 0.1f, 0.1f); 
  bumpmapSep->addChild(m_material);
  bumpmapSep->addChild(createShader());
  root->addChild(shaderSwitch);  

  //Create the first color map
  SoColorMap *colorMap = new SoColorMap;
  colorMap->predefinedColorMap = SoColorMap::TEMPERATURE;  
  colorMap->max = 255;

  //First indexed texture
  SoIndexedTexture2 *indexedTexture = new SoIndexedTexture2 ;
  indexedTexture->wrapS = SoTexture2::CLAMP_TO_EDGE ;
  indexedTexture->wrapT = SoTexture2::CLAMP_TO_EDGE ;          
  indexedTexture->minFilter = SoTexture2::LINEAR ;          
  indexedTexture->magFilter = SoTexture2::LINEAR ;          
  root->addChild(colorMap);    
  root->addChild(indexedTexture) ;
  SoShapeHints *shapeHints = new SoShapeHints;
  shapeHints->vertexOrdering = SoShapeHints::COUNTERCLOCKWISE;     
  shapeHints->shapeType = SoShapeHints::UNKNOWN_SHAPE_TYPE;  
  shapeHints->creaseAngle = 40;
  root->addChild(shapeHints);

  SoSwitch *shapeSwitch = new SoSwitch;  
  shapeSwitch->addChild(createPlan()) ;
  shapeSwitch->addChild(new SoSphere) ;
  shapeSwitch->addChild(createSinSurface()) ;
  root->addChild(shapeSwitch) ;  
  shapeSwitch->whichChild = 0;

  m_mtlEditor = new SoXtMaterialEditor();
  m_mtlEditor->setTitle("Material of Volume Rendering");
  m_mtlEditor->attach(m_material);

  // When the material editor comes up it does not display the
  // actual values in this material.  Probably a bug, but this
  // should force it to be correct.
  m_mtlEditor->setMaterial( *m_material );

  Widget parent = buildInterface(myWindow, colorMap, indexedTexture, shapeSwitch);

  myViewer = new SoXtExaminerViewer(parent);
  myViewer->setHeadlight(FALSE);
  myViewer->setSceneGraph(root);
   
  //Attach the default SodirectionalLight to the light editor
  m_headlightEd->attach(new SoPath(light));

//  camSwitch->whichChild = 1;
  myViewer->viewAll();
  myViewer->saveHomePosition(); // not automatic when we have our own camera

  myViewer->setTransparencyType(SoGLRenderAction::OPAQUE_FIRST);
  myViewer->setTitle(SO_TITLE);
  myViewer->show();

  SoXt::show(myWindow);
  SoXt::mainLoop();
  SoDialogViz::finish();
  SoXt::finish();

  return 0;
}/*---------------------------------------------------------------------------*/

void
fillModelsList(SoDialogComboBox *cb)
{
  std::vector<SbString> paths;
  paths.push_back("");
  //paths.push_back("../../data/3DTexture/");
  paths.push_back(SbFileHelper::expandString("$OIVHOME/examples/data/Inventor/3DTexture/"));

  SbString oivhome = SbFileHelper::expandString("$OIVHOME");
  if(! oivhome.isEmpty() ) {
    SbString home(oivhome.toLatin1());
    home += "/examples/data/VolumeViz/";
    paths.push_back(home);
  }

#ifdef _WIN32
  for(size_t i = 0; i < paths.size(); i++) {
    SbString pathname = paths[i];
    pathname += "*.vol";
    WIN32_FIND_DATA FindFileData;
    HANDLE hFind;     

    hFind = FindFirstFile(pathname.getString(), &FindFileData);
    if(hFind == INVALID_HANDLE_VALUE)
      continue;
    cb->addItem(SbString(FindFileData.cFileName));    
    while (FindNextFile(hFind, &FindFileData) != 0) 
      cb->addItem(SbString(FindFileData.cFileName));    
    FindClose(hFind);
  }
#else
  for(size_t i = 0; i < paths.size(); i++) {
    DIR *dp;
    struct dirent *dir_entry;

    dp = opendir(paths[i].getString());
    if(!dp)
      continue;
    while( (dir_entry = readdir(dp)) != NULL) {
      if(strstr(dir_entry->d_name, ".vol")||strstr(dir_entry->d_name, ".VOL")) {
        cb->addItem(SbString(dir_entry->d_name));
      }
    }
    closedir(dp);
  }
#endif
}/***************************************************************************/

Widget
buildInterface(Widget window, SoColorMap *colorMap, SoIndexedTexture2 *indexedTexture, SoSwitch *shapeSwitch)
{
  SoInput myInput;
  if (! myInput.openFile( "$OIVHOME/examples/source/Inventor/Features/IndexedTexture/IndexedTexture.iv" ))
    return NULL;

  SoGroup *myGroup = SoDB::readAll( &myInput );
  if (! myGroup)
    return NULL;

  SoTopLevelDialog *myTopLevelDialog = (SoTopLevelDialog *)myGroup->getChild( 0 );
  
  auditor = new MyAuditorClass(colorMap, indexedTexture, myTopLevelDialog, shapeSwitch, depthParam,
 		                                           m_headlightEd, texSizeParam, m_mtlEditor, shaderSwitch, camSwitch);
  myTopLevelDialog->addAuditor(auditor);

  auditor->loadModel(DEFAULT_FILE_NAME);

  SoDialogComboBox *cbModels = (SoDialogComboBox*)myTopLevelDialog->searchForAuditorId(SbString("volmodel"));
  fillModelsList(cbModels);

  SoDialogCustom *customNode = (SoDialogCustom *)myTopLevelDialog->searchForAuditorId(SbString("Viewer"));

  myTopLevelDialog->buildDialog( window, customNode != NULL );
  myTopLevelDialog->show();

  return customNode ? customNode->getWidget() : window;
}/***************************************************************************/

SoIndexedFaceSet *
createSinSurface()
{
  int j;
  SoIndexedFaceSet *myFaceSet = new SoIndexedFaceSet;
  int sizex = 32;
  int sizey = 32;
  SbVec3f *vertexPositions = new SbVec3f[sizex*sizey];
  int32_t *indices = new int32_t[5*(sizex-1)*(sizey-1)];
  int ofs = 0;

  for(j = 0; j < sizey; j++)  
    for(int i = 0; i < sizex; i++)
      vertexPositions[ofs++] = SbVec3f((float)((i-sizex/2)*0.1), 
                                       (float)(sin(2*M_PI*i/sizex)*0.8), 
                                       (float)((j-sizey/2)*0.1));

  ofs = 0;
  for(j = 0; j < sizey-1; j++)
    for(int i = 0; i < sizex-1; i++) {
      indices[ofs] = i+0+j*sizex;
      indices[ofs+1] = i+sizex+j*sizex;
      indices[ofs+2] = i+sizex+1+j*sizex;    
      indices[ofs+3] = i+1+j*sizex;    
      indices[ofs+4] = SO_END_FACE_INDEX;
      ofs += 5;
    }
  
  SoVertexProperty *myVertexProperty = new SoVertexProperty;

  // Define coordinates for vertices
  myVertexProperty->vertex.setValues(0, sizex*sizey, vertexPositions);
  myFaceSet->vertexProperty.setValue(myVertexProperty);

   myFaceSet->coordIndex.setValues(0, 5*(sizex-1)*(sizey-1), indices);

  delete[] vertexPositions;
  delete[] indices;

  return myFaceSet;
}/***************************************************************************/


SoFaceSet *
createPlan()
{
  SoFaceSet *plan = new SoFaceSet; 
  SoVertexProperty *vertices = new SoVertexProperty;
  plan->vertexProperty = vertices;
  vertices->vertex.set1Value(0,  SbVec3f(-1, 1, 0));
  vertices->vertex.set1Value(1,  SbVec3f(-1, -1, 0));
  vertices->vertex.set1Value(2,  SbVec3f(1, -1, 0));
  vertices->vertex.set1Value(3,  SbVec3f(1, 1, 0));

  return plan;
}/***************************************************************************/


