#include "auditor.h"
#include <Inventor/STL/fstream>
#include <Inventor/STL/vector>

extern int ReadVolFile(const SbString&, int &, int &, int &, unsigned char *&);
/***************************************************************************/

unsigned char *
MyAuditorClass::createDefaultTexture(int w, int h, int d)
{
  unsigned char *res = new unsigned char[w*h*d];
  int i, j, k;

  for(k = 0; k < d; k++)
    for(j = 0; j < h; j++)
      for(i = 0; i < w; i++) {
        float x = i-w/2.f;
        float y = j-h/2.f;
        float z = k-d/2.f;
        float d = (4*(x*x+y*y+z*z)/(w*w+h*h+z*z))*255;
        d = d>255?255:d;
        res[i+j*w+k*w*h] = (unsigned char)d;
      }

  return res;
}/***************************************************************************/

void
MyAuditorClass::loadModel(const SbString &name)
{
  SbString fullname;
  unsigned char *bytes = NULL;  

  std::vector<SbString> paths;
  paths.push_back("");
  paths.push_back("../../data/3DTexture/");

  const char* oivhome = SoPreferences::getValue("OIVHOME");
  if(oivhome) {
    SbString home(oivhome);
    home += "/examples/data/VolumeViz/";
    paths.push_back(  home);
  }
   
  std::ifstream fs;
  int i = 0;
  int numPaths = (int)paths.size();
  bool found;
  do {
    fullname = paths[i++];
    fullname += name;
    fs.open(fullname.getString());            
    found = fs.is_open();
  }while(!found && i < numPaths);
  
  if(found) {
    fs.close();

    // Load the volume data
    int ok = 0;    
    ok = ReadVolFile(fullname.getString(), nx, ny, nz, bytes);  
    if (!ok || nx <= 0 || ny <= 0 || nz <= 0) {
      printf("Can't read volume data %s\n", fullname.getString());
      return;
    }
  } else {  
    nx = 64; ny = 64; nz = 64; 
    bytes = createDefaultTexture(nx, ny, nz);    
  }      

  texSizeParam->value = float(nx);
  delete[] volBytes;
  volBytes = bytes;
  SoDialogIntegerSlider *sliceSel = (SoDialogIntegerSlider*)topLevelDialog->searchForAuditorId(SbString("slicesel"));
  sliceSel->max = nz-1;      
  texture->imageIndex.setValue(SbVec2s(nx,ny), SoSFArray2D::UNSIGNED_BYTE, volBytes+nx*ny*(sliceSel->value.getValue()));
}/***************************************************************************/

void
MyAuditorClass::dialogComboBox(SoDialogComboBox* cpt)
{
  int selectedItem = cpt->selectedItem.getValue();
  if (cpt->auditorID.getValue() == "colormap"){
    doCmapChange( selectedItem );
  } else if (cpt->auditorID.getValue() == "volmodel") {
    loadModel(cpt->items[selectedItem].getString());
  } else if (cpt->auditorID.getValue() == "shapetype") {
    shapeSwitch->whichChild = selectedItem;
  }
}/***************************************************************************/

MyAuditorClass::MyAuditorClass( SoColorMap* cm,
                                SoIndexedTexture2* tex,
                                SoTopLevelDialog* topLevelDialog,
                                SoSwitch* shapeSwitch,
                                SoShaderParameter1f* depthParam,
                                SoXtDirectionalLightEditor* headlightEd,
                                SoShaderParameter1f* texSizeParam,
                                SoXtMaterialEditor* m_mtlEditor,
                                SoSwitch* shaderSwitch,
                                SoSwitch* camSwitch )
  : camSwitch( camSwitch )
  , shapeSwitch( shapeSwitch )
  , shaderSwitch( shaderSwitch )
  , m_mtlEditor( m_mtlEditor )
  , m_headlightEd( headlightEd )
  , depthParam( depthParam )
  , colorMap( cm )
  , texSizeParam( texSizeParam )
  , texture( tex )
  , topLevelDialog( topLevelDialog )
  , volBytes( 0 )
{
}/***************************************************************************/

void
MyAuditorClass::dialogRealSlider(SoDialogRealSlider* cpt)
{
  float value = cpt->value.getValue();
  //colormap min
  if (cpt->auditorID.getValue() == "colormap1min") {        
    if(value <= colorMap->max.getValue())
      colorMap->min.setValue(value);        
  }
    
  //colormap max
  if (cpt->auditorID.getValue() == "colormap1max") {
    if(value >= colorMap->min.getValue())
      colorMap->max.setValue(value);        
  }

  if (cpt->auditorID.getValue() == "datamax") {
    if(value >= texture->minValue.getValue())
      texture->maxValue.setValue(value);            
  }

  if (cpt->auditorID.getValue() == "datamin") {
    if(value <= texture->maxValue.getValue())
    texture->minValue.setValue(value);            
  }
}/***************************************************************************/

void
MyAuditorClass::dialogIntegerSlider(SoDialogIntegerSlider* cpt)
{
  int value = cpt->value.getValue();  
  if (cpt->auditorID.getValue() == "slicesel") {
    texture->imageIndex.setValue(SbVec2s(nx,ny), SoSFArray2D::UNSIGNED_BYTE, volBytes+nx*ny*value);
  }
}/***************************************************************************/

void 
MyAuditorClass::doCmapChange( int selectedItem )
{
  SoDialogRealSlider *minSlider = (SoDialogRealSlider*)topLevelDialog->searchForAuditorId(SbString("colormap1min"));
  SoDialogRealSlider *maxSlider = (SoDialogRealSlider*)topLevelDialog->searchForAuditorId(SbString("colormap1max"));    
  switch (selectedItem) {
    case 0:
    {
      colorMap->predefinedColorMap = SoColorMap::NONE;
      colorMap->colorMapFormat = SoColorMap::RGB;
      colorMap->colorMap.setNum(256*3);
      float *data = colorMap->colorMap.startEditing();
      for(int i = 0; i < 256*3; i+=3) {
        data[i] = float((sin(2*M_PI*0.5*i/768.)+1)*0.5);
        data[i+1] = float((sin(3*2*M_PI*0.5*i/768.)+1)*0.5);
        data[i+2] = float((cos(2*M_PI*0.5*i/768.)+1)*0.5);
      }
      colorMap->colorMap.finishEditing();
      break;
    }
    case 1:
      colorMap->predefinedColorMap = SoColorMap::SEISMIC;
      break;
    case 2:
      colorMap->predefinedColorMap = SoColorMap::STANDARD;
      break;
    case 3:
      colorMap->predefinedColorMap = SoColorMap::GLOW;
      break;
    case 4:
      colorMap->predefinedColorMap = SoColorMap::BLUE_RED;
      break;
    case 5:
      colorMap->predefinedColorMap = SoColorMap::PHYSICS;
      break;
    case 6:
      colorMap->predefinedColorMap = SoColorMap::TEMPERATURE;
      break;
    case 7:
      colorMap->predefinedColorMap = SoColorMap::GRAY;
      break;
    case 8:
      colorMap->predefinedColorMap = SoColorMap::BLUE_WHITE_RED;
      break;
    case 9:
      colorMap->predefinedColorMap = SoColorMap::INTENSITY;
      break;
    default:
      break;
  }      
  colorMap->min.setValue(minSlider->value.getValue());    
  colorMap->max.setValue(maxSlider->value.getValue());    
}/***************************************************************************/

void 
MyAuditorClass::dialogEditText(SoDialogEditText* cpt)
{    
  if (cpt->auditorID.getValue() == "bumpscale") {
    float value = (float)atof((cpt->editText.getValue()).getString());    
    depthParam->value = value;
  }
}/***************************************************************************/

void 
MyAuditorClass::dialogPushButton(SoDialogPushButton* cpt)
{		 
  if (cpt->auditorID.getValue() == "light")
 		m_headlightEd->show();
   else if (cpt->auditorID.getValue() == "material")
		m_mtlEditor->show();
}/***************************************************************************/

void
MyAuditorClass::dialogCheckBox(SoDialogCheckBox* cpt)
{
  SbBool state = cpt->state.getValue();

  if (cpt->auditorID.getValue() == "bump") {
    camSwitch->whichChild = state?0:1;
    shaderSwitch->whichChild = state?0:-1;  
  }
}/***************************************************************************/


