#ifndef AUDITOR_H
#define AUDITOR_H

#include <DialogViz/SoDialogVizAll.h>
#include <Inventor/nodes/SoIndexedTexture2.h>
#include <Inventor/nodes/SoColorMap.h>
#include <Inventor/nodes/SoSwitch.h>
#include <Inventor/nodes/SoShaderProgram.h>
#include <Inventor/nodes/SoFragmentShader.h>
#include <Inventor/nodes/SoVertexShader.h>
#include <Inventor/nodes/SoShaderParameter.h> 
#include <Inventor/nodes/SoMaterial.h> 
#include <Inventor/Xt/SoXtDirectionalLightEditor.h>
#include <Inventor/Xt/SoXtMaterialEditor.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>

class MyAuditorClass : public SoDialogAuditor
{
public:
  MyAuditorClass(SoColorMap *cm, SoIndexedTexture2 *tex, SoTopLevelDialog *topLevelDialog,
                 SoSwitch *shapeSwitch, SoShaderParameter1f *depthParam, SoXtDirectionalLightEditor *headlightEd,
                 SoShaderParameter1f *texSizeParam, SoXtMaterialEditor *m_mtlEditor, SoSwitch *shaderSwitch,
                 SoSwitch *camSwitch);
  
  void loadModel(const SbString &name);

private:
  SoSwitch *camSwitch;
  SoSwitch *shapeSwitch;
  SoSwitch *shaderSwitch;
  SoXtMaterialEditor *m_mtlEditor;
  SoXtDirectionalLightEditor *m_headlightEd;
  SoShaderParameter1f *depthParam;
  SoColorMap *colorMap;
  SoShaderParameter1f *texSizeParam;
  SoIndexedTexture2 *texture;
  SoTopLevelDialog *topLevelDialog;
  unsigned char *volBytes;
  int nx, ny, nz;

  void dialogEditText(SoDialogEditText* cpt);
  void dialogIntegerSlider(SoDialogIntegerSlider* cpt);
  void dialogRealSlider(SoDialogRealSlider* cpt);
  void dialogComboBox(SoDialogComboBox* cpt);
  void doCmapChange( int selectedItem );  
  void dialogPushButton(SoDialogPushButton* cpt); 
  void dialogCheckBox(SoDialogCheckBox* cpt);

  unsigned char *createDefaultTexture(int w, int h, int d);
};

#endif

