/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2020 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Modified by : VSG (SEP 2012)
**=======================================================================*/

#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/SoXtRenderArea.h>
#include <Inventor/nodes/SoCone.h>
#include <Inventor/nodes/SoDirectionalLight.h>
#include <Inventor/nodes/SoMaterial.h>
#include <Inventor/nodes/SoPerspectiveCamera.h>
#include <Inventor/nodes/SoSeparator.h>

#include <Inventor/lock/SoLicensedProduct.h>
#include <Inventor/lock/SoLicensesInfo.h>
#include <Inventor/lock/SoLicenseProperty.h>
#include <Inventor/SbString.h>

void 
callback( SoLicensedProduct::SbProduct /*product*/ )
{
   std::cout << "callback message...";
}

int
main( int, char **argv )
{
  SoLicensesInfo& licensesInfo = SoLicensesInfo::getInstance();

  // Number of licensed product.
  unsigned int count = licensesInfo.getProductCount();
  std::cout << count << " product" << ((count == 1) ? "" : "s") << std::endl;

  licensesInfo.registerExpirationCallback( *callback );

  for ( unsigned int i = 0; i < count; i++ )
  {
    const SoLicensedProduct* product = licensesInfo.getLicensedProductByIndex( i );

    if ( product == NULL )
      continue;

    // Name of the product
    SbString productName = product->getProductName();

    unsigned int numLicenses = product->getLicenseCount();

    std::cout << numLicenses << " license" << ((numLicenses == 1) ? "" : "s") << " for product " << productName << std::endl;

    if ( numLicenses == 0 )
      std::cout << "No license available for product " << productName << std::endl;

    for ( unsigned int j = 0; j < numLicenses; j++ )
    {
      const SoLicenseProperty* license = product->getLicenseByIndex( j );

      if ( license == NULL )
        continue;

      // License type
      SoLicenseProperty::SbLicenseType type = license->getLicenseType();

      if ( j == 0 )
        std::cout << "Licenses of product " << license->getProductName() << std::endl << std::endl;

      std::string buffer;
      buffer = "VSG: [1.5] \tLicense ";
      buffer += license->getProductName().toStdString();
      buffer += " ";
      buffer += license->getProductVersion().toStdString();
      buffer += " ";
      buffer += license->getExpirationDate().toStdString();
      buffer += " ";
      buffer += license->getNumUsers().toStdString();
      buffer += " ";
      buffer += license->getCheckSum().toStdString();
      buffer += " \"";
      buffer += license->getInfo().toStdString();
      buffer += "\" ";
      buffer += license->getHostID().toStdString();
      buffer += "\n";

      std::cout << "version " << license->getProductVersion() << "\t";

      if ( license->isExpired() )
        std::cout << "Expired!" << std::endl;
      else if ( license->isMasterPassword() )
        std::cout << "Master Password" << std::endl;
      else
        std::cout << "Days to expire : " << license->getDaysToExpire() << std::endl;

      std::cout << buffer << "License " << ((type == SoLicenseProperty::RT) ? "RT" : "SDK") << std::endl << "______" << std::endl;
    }
  }
  
  // Exemple using OpenInventor. This utilisation needs a valid license.
  Widget myWindow = SoXt::init(argv[0]);
  SoSeparator *root = new SoSeparator;
  SoPerspectiveCamera *myCamera = new SoPerspectiveCamera;
  root->ref();
  root->addChild(myCamera);
  root->addChild(new SoDirectionalLight);
  root->addChild(new SoCone);
  SoXtRenderArea *myRenderArea = new SoXtRenderArea(myWindow);
  
  myCamera->viewAll(root, myRenderArea->getViewportRegion());

  myRenderArea->setSceneGraph(root);
  myRenderArea->show();
  SoXt::show(myWindow);
  SoXt::mainLoop();
  

  return EXIT_SUCCESS;
}
