#include <DialogViz/SoDialogVizAll.h>
#include <DialogViz/dialog/SoDialogViz.h>
#include <Inventor/SoDB.h>
#include <Inventor/SoInput.h>
#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoGradientBackground.h>
#include "Inventor/nodes/SoMaterial.h"
#include "Inventor/nodes/SoLightModel.h"

#include "utils.h"

namespace application
{
  class LightModelAuditor : public SoDialogChoiceAuditor
  {
  private:
    SoLightModel* lightModel;

  public:
    LightModelAuditor( SoLightModel* lightModel )
      : lightModel( lightModel )
    {}

    virtual void dialogChoice( SoDialogChoice* dialogChoice )
    {
      lightModel->model.setValue( dialogChoice->selectedItem.getValue() );
    }
  };
}

int
main( int /*argc*/, char **argv )
{
  SoWidget window = SoXt::init( argv[0] );
  SoDialogViz::init();

  {
    SoInput gui_input;
    SoInput scene_input;
    gui_input.openFile( "$OIVHOME/examples/source/Inventor/Features/LightModel/gui.iv" );
    scene_input.openFile( "$OIVHOME/examples/source/Inventor/Features/LightModel/scene.iv" );

    SoSeparator* gui = SoDB::readAll( &gui_input );
    SoRef<SoSeparator> scene = SoDB::readAll( &scene_input );

    SoTopLevelDialog* rootDialog = find<SoTopLevelDialog>(gui, "GUI");
    rootDialog->buildDialog( window, true );

    SoLightModel* lightModel = find<SoLightModel>(scene.ptr(), "NODE_LIGHT_MODEL");

    SoDialogComboBox* comboBox = find<SoDialogComboBox>(rootDialog, "light model");
    application::LightModelAuditor* auditor = new application::LightModelAuditor(lightModel);
    comboBox->addAuditor(auditor);

    SoNode* viewer1 = gui->getByName("VIEWER");
    SoWidget viewerWidget =  static_cast<SoDialogCustom*>( viewer1 )->getWidget();
    SoXtExaminerViewer* viewer = new SoXtExaminerViewer( viewerWidget );
    viewer->setSceneGraph( scene.ptr() );
    viewer->show();
    viewer->viewAll();

    SoXt::show( window );
    SoXt::mainLoop();

    delete viewer;
  }

  SoDialogViz::finish();
  SoXt::finish();

  return EXIT_SUCCESS;
}
