/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2020 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
/*--------------------------------------------------------------
 *  This example builds several lineSet to test the push/pop 
 *  in SoDrawStyle line pattern scale factor.
 *------------------------------------------------------------*/

#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/nodes/SoCoordinate3.h>
#include <Inventor/nodes/SoLineSet.h>
#include <Inventor/nodes/SoMaterial.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoTranslation.h>
#include <Inventor/nodes/SoDrawStyle.h>

static const float 
vertices[2][3] =
{
  {  0.0f, 0.0f, 0.0f }, 
  { 10.0f, 0.0f, 0.0f }
};

SoSeparator *
makeLine(SbColor color, unsigned short pattern, int scaleFactor)
{
  SoSeparator *lineGroup = new SoSeparator();
  lineGroup->ref();
  
  // Set the draw style for lineGroup.
  SoDrawStyle *myDrawStyle = new SoDrawStyle;
  myDrawStyle->linePattern = pattern;
  myDrawStyle->linePatternScaleFactor = scaleFactor;
  lineGroup->addChild(myDrawStyle);

  // Define material for lineGroup
  SoMaterial *myMaterial = new SoMaterial;
  myMaterial->diffuseColor.setValue(color);
  lineGroup->addChild(myMaterial);
  
  // Define coordinates for vertices
  SoCoordinate3 *myCoords = new SoCoordinate3;
  myCoords->point.setValues(0, 2, vertices);
  lineGroup->addChild(myCoords);
  
  // Define the FaceSet
  SoLineSet *myLineSet = new SoLineSet;
  lineGroup->addChild(myLineSet);
  
  lineGroup->unrefNoDelete();
  return lineGroup;
}

int
main(int, char **argv)
{
  // Initialize Inventor and Xt
  Widget myWindow = SoXt::init(argv[0]);
  if (myWindow == NULL) exit(1);
  
  SoSeparator *root = new SoSeparator;
  root->ref();
  
  SoTranslation *translate = new SoTranslation;
  translate->translation.setValue(SbVec3f(0.0F, -1.0F, 0.0F));

  root->addChild(makeLine(SbColor(1.0F, 0.0F, 0.0F), 0xF222, 3));

  root->addChild(translate);

  root->addChild(makeLine(SbColor(0.0F, 1.0F, 0.0F), 0xF222, 5));
  
  root->addChild(translate);

  SoCoordinate3 *myCoords = new SoCoordinate3;
  myCoords->point.setValues(0, 2, vertices);
  root->addChild(myCoords);
  SoLineSet *myLineSet1 = new SoLineSet;
  root->addChild(myLineSet1);

  // Set the draw style for the following lines.
  SoDrawStyle *myDrawStyle = new SoDrawStyle;
  myDrawStyle->linePattern = 0x1111;
  root->addChild(myDrawStyle);

  root->addChild(translate);

  SoMaterial *myMaterial = new SoMaterial;
  myMaterial->diffuseColor.setValue(SbColor(0.0F, 0.0F, 1.0F));
  root->addChild(myMaterial);
  SoLineSet *myLineSet2 = new SoLineSet;
  root->addChild(myLineSet2);

  SoXtExaminerViewer *myViewer = 
    new SoXtExaminerViewer(myWindow);
  myViewer->setSceneGraph(root);
  myViewer->setTitle("Test: push/pop SoDrawStyle line pattern scale factor");
  myViewer->show();
  myViewer->viewAll();
  
  SoXt::show(myWindow);
  SoXt::mainLoop();

  root->unref();
  delete myViewer;
  SoXt::finish();
  
  return 0;
}



