/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2020 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/

#include <Inventor/SoDB.h>         
#include <Inventor/SbColor.h>

#include <Inventor/Xt/SoXt.h>         
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>  

#include <Inventor/events/SoKeyboardEvent.h>

#include <Inventor/MPEG/SoMPEGFrameRenderer.h>

#include <Inventor/nodes/SoEventCallback.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoSwitch.h>
#include <Inventor/nodes/SoFont.h>
#include <Inventor/nodes/SoLightModel.h>
#include <Inventor/nodes/SoBaseColor.h>
#include <Inventor/nodes/SoText2.h>
#include <Inventor/nodes/SoTranslation.h>
#include <Inventor/nodes/SoPerspectiveCamera.h>



SoMPEGFrameRenderer *MPEGRenderer ;
SoSwitch			*InfoSwitch ;

/*---------------------------------------------------------------------------*/

void 
myKeyPressCB (void *, SoEventCallback *eventCB) 
{

   const SoEvent *event = eventCB->getEvent();

   // check for the keys being pressed
   if (SO_KEY_PRESS_EVENT(event, A)) {
	 int savedSwitchValue = InfoSwitch->whichChild.getValue() ;
	 InfoSwitch->whichChild = SO_SWITCH_NONE ;
     MPEGRenderer->recordFrame(2);
	 InfoSwitch->whichChild = savedSwitchValue ;
   } 
   else if (SO_KEY_PRESS_EVENT(event, C)) {
	 MPEGRenderer->closeFile();
	 delete MPEGRenderer ;
	 exit(0) ;
   }
   else if (SO_KEY_PRESS_EVENT(event, H)) {
	   if(InfoSwitch->whichChild.getValue() == SO_SWITCH_ALL)
		   InfoSwitch->whichChild = SO_SWITCH_NONE ;
	   else
		   InfoSwitch->whichChild = SO_SWITCH_ALL ;   
   }
}/*---------------------------------------------------------------------------*/

SoSwitch*
displayInfo() 
{
	// Informations
	SoSwitch *infoSwitch = new SoSwitch ;
	infoSwitch->ref() ;
	infoSwitch->whichChild = SO_SWITCH_ALL ;

	SoSeparator *infoSep = new SoSeparator ;
	infoSwitch->addChild(infoSep) ;

	SoLightModel *lModel = new SoLightModel ;
	lModel->model = SoLightModel::BASE_COLOR ;
	infoSep->addChild(lModel) ;

	SoFont *fontInfo = new SoFont ;
	fontInfo->name = "Courier New" ;
	fontInfo->size = 12 ;
	infoSep->addChild(fontInfo) ;

	SoBaseColor *infoColor = new SoBaseColor ;
	infoColor->rgb.setValue(SbColor(1, 1, 0.f)) ;
	infoSep->addChild(infoColor) ;

	SoTranslation *transInfo = new SoTranslation ;
	transInfo->translation.setValue(-0.95f, 0.95f, 0.) ;
	infoSep->addChild(transInfo) ;

	SoText2 *infoText = new SoText2 ;
	infoText->string.set1Value(0, "H : Toggle this display") ;
	infoText->string.set1Value(1, "A : Add a new frame to the MPEG file") ;
	infoText->string.set1Value(2, "C : Close the file MPEGOutput.mpg and Exit") ;
	infoSep->addChild(infoText) ;

	infoSwitch->unrefNoDelete() ;
	return infoSwitch ;
}/*---------------------------------------------------------------------------*/

int 
main(int , char **) 
{

   // Initialize Inventor and Xt
   Widget myWindow = SoXt::init("MPEGFrameRenderer");

   // Build the viewer in the applications main window
   SoXtExaminerViewer *myViewer = new SoXtExaminerViewer(myWindow);
   
   // Read the geometry from a file and add to the scene
   SoInput myInput;
   if (!myInput.openFile("$OIVHOME/examples/data/Inventor/jumpyMan.iv"))
      exit (1);

   SoSeparator *geomObject = SoDB::readAll(&myInput);
   if (geomObject == NULL)
      exit (1);
   
   // Create the MPEG renderer
   MPEGRenderer = new SoMPEGFrameRenderer ();
   MPEGRenderer->setSize (SbVec2s (300, 300));
   MPEGRenderer->setCompressionRate(0.);
   MPEGRenderer->setBitPerSec(-1);

   int i = 0;
   char mpegFileName[20] = "MPEGOutput.mpg";
   while (!MPEGRenderer->openFile(mpegFileName)) {
     sprintf(mpegFileName, "MPEGOutput%d.mpg", i);
     i++;
   }

   // Build the scene graph
   SoSeparator *root = new SoSeparator ;
   root->ref() ;
   InfoSwitch = displayInfo() ;
   root->addChild(InfoSwitch) ;

   SoPerspectiveCamera *camera = new SoPerspectiveCamera ;
   root->addChild(camera) ;

   root->addChild(geomObject) ;

   // Track the keyboard events
   SoEventCallback *myEventCB = new SoEventCallback;
   myEventCB->addEventCallback(SoKeyboardEvent::getClassTypeId(),
	                           myKeyPressCB, myViewer);
   root->addChild(myEventCB);

   // Attach the viewer to the scene graph
   myViewer->setSceneGraph(root);
   MPEGRenderer->setShareContext(myViewer->getShareContext());
   MPEGRenderer->setSceneGraph(myViewer->getSceneManager()->getSceneGraph());

   camera->viewAll(geomObject, myViewer->getViewportRegion()) ;

   // Show the main window
   myViewer->show();
   SoXt::show(myWindow);

   // Loop forever
   SoXt::mainLoop();

   root->unref();
   delete myViewer;
   delete MPEGRenderer;
   SoXt::finish();

   return 0;
}/*---------------------------------------------------------------------------*/


