/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2020 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : P. ESTRADE (Jun 2001)
**=======================================================================*/

#if !defined(AFX_MAGELLANMFCVIEW_H__3309BEDC_4B83_4221_B380_DD9E579A3F19__INCLUDED_)
#define AFX_MAGELLANMFCVIEW_H__3309BEDC_4B83_4221_B380_DD9E579A3F19__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include <Inventor/nodes/SoEventCallback.h>
#include <Inventor/Xt/devices/SoXtSpaceball.h>

class SoWinExaminerViewer;
class SoSeparator;
class SoShape;
class SoTranslation;
class SoRotation;

class CMagellanMfcView : public CView
{
protected: // create from serialization only
	CMagellanMfcView();
	DECLARE_DYNCREATE(CMagellanMfcView)

// Attributes
public:
	CMagellanMfcDoc* GetDocument();

// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CMagellanMfcView)
	public:
	virtual void OnDraw(CDC* pDC);  // overridden to draw this view
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	virtual void OnInitialUpdate();
	protected:
	virtual BOOL OnPreparePrinting(CPrintInfo* pInfo);
	virtual void OnBeginPrinting(CDC* pDC, CPrintInfo* pInfo);
	virtual void OnEndPrinting(CDC* pDC, CPrintInfo* pInfo);
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CMagellanMfcView();
#if defined(_DEBUG)
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

// BEGIN OIV
//
private:
	SoWinExaminerViewer *m_pViewer;
	SoSeparator *m_pSceneRoot;
	SoTranslation* m_translation;
	SoRotation *m_rotation;
	SoXtSpaceball *m_sb;
	float  m_rotScaleFactor;
	float  m_transScaleFactor;
	SbBool m_rotationMode;
	SbBool m_translationMode;

// Callback
	static void spaceballButtonCB( void *, SoEventCallback *cb );
	static void motion3TranslationCB( void *, SoEventCallback *cb );
	static void motion3RotationCB( void *, SoEventCallback *cb );
//
// END OIV

protected:

// Generated message map functions
protected:
	//{{AFX_MSG(CMagellanMfcView)
	afx_msg void OnDestroy();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

#if !defined(_DEBUG)  // debug version in MagellanMfcView.cpp
inline CMagellanMfcDoc* CMagellanMfcView::GetDocument()
   { return (CMagellanMfcDoc*)m_pDocument; }
#endif

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_MAGELLANMFCVIEW_H__3309BEDC_4B83_4221_B380_DD9E579A3F19__INCLUDED_)


