#include <DialogViz/SoDialogVizAll.h>
#include <DialogViz/dialog/SoDialogViz.h>
#include <Inventor/SoDB.h>
#include <Inventor/SoInput.h>
#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoMultipleInstance.h>
#include <Inventor/nodes/SoColorMap.h>
#include <Inventor/nodes/SoAlgebraicShape.h>
#include <Inventor/devices/SoGpuBufferObject.h>
#include <Inventor/devices/SoGLContext.h>
#include <Inventor/nodes/SoAlgebraicSphere.h>
#include <Inventor/nodes/SoAlgebraicCylinder.h>
#include <Inventor/nodes/SoAlgebraicCone.h>
#include <Inventor/nodes/SoMaterial.h>
#include <Inventor/nodes/SoGradientBackground.h>

#include <algorithm>

#include "BufferObjectMapper.h"

#define NUM_INSTANCE_SPHERE_X 50
#define NUM_INSTANCE_SPHERE_Y NUM_INSTANCE_SPHERE_X
#define NUM_INSTANCE_SPHERE_Z NUM_INSTANCE_SPHERE_X

#define NUM_INSTANCE_SPHERE (NUM_INSTANCE_SPHERE_X*NUM_INSTANCE_SPHERE_Y*NUM_INSTANCE_SPHERE_Z)

static std::string s_resourceRootDir;

static void
buildSG ( SoSeparator* root, SoDialogRealSlider* sRadius, SoDialogRealSlider* cMin, SoDialogRealSlider* cMax )
{
  SoRef<SoSeparator> newScene = new SoSeparator;

  // add color map
  SoColorMap *colorMap = new SoColorMap;
  colorMap->predefinedColorMap = SoColorMap::STANDARD;
  newScene->addChild(colorMap);

  // create spheres
  {
    // Create SoMultipleInstance group node where to add our geometry
    SoMultipleInstance* multiInstanceGroup = new SoMultipleInstance;
    multiInstanceGroup->numInstances = NUM_INSTANCE_SPHERE;
    newScene->addChild(multiInstanceGroup);

    // translation attribute
    {
      SoInstanceParameter* vertexParameters = new SoInstanceParameter;
      vertexParameters->components = 3;
      vertexParameters->type = SbDataType::FLOAT;
      {
        SoGpuBufferObject* bufferValues = new SoGpuBufferObject;
        bufferValues->setSize(NUM_INSTANCE_SPHERE*sizeof(SbVec3f));
        {
          BufferObjectMapper<SbVec3f> traMapping(bufferValues, SoBufferObject::SET);
          for (int k = 0; k < NUM_INSTANCE_SPHERE_Z; k++)
            for (int j = 0; j < NUM_INSTANCE_SPHERE_Y; j++)
              for (int i = 0; i < NUM_INSTANCE_SPHERE_X; i++)
                traMapping[i+j*NUM_INSTANCE_SPHERE_X+k*NUM_INSTANCE_SPHERE_X*NUM_INSTANCE_SPHERE_Y].setValue(i*4.f, j*4.f, k*4.f);
        }

        vertexParameters->value.setValue(bufferValues);
      }
      vertexParameters->name  = SoInstanceParameter::getPredefinedParameterName(SoInstanceParameter::TRANSLATION);
      multiInstanceGroup->parameters.set1Value(0, vertexParameters);
    }

    // scale attribute
    {
      SoInstanceParameter* vertexParameters = new SoInstanceParameter;
      vertexParameters->components = 3;
      vertexParameters->type = SbDataType::FLOAT;
      {
        SoGpuBufferObject* bufferValues = new SoGpuBufferObject;
        bufferValues->setSize(NUM_INSTANCE_SPHERE*sizeof(SbVec3f));
        {
          BufferObjectMapper<SbVec3f> scaMapping(bufferValues, SoBufferObject::SET);
          for (int k = 0; k < NUM_INSTANCE_SPHERE_Z; k++) {
            for (int j = 0; j < NUM_INSTANCE_SPHERE_Y; j++) {
              for (int i = 0; i < NUM_INSTANCE_SPHERE_X; i++) {
                float s = 1.f + 0.5f*cosf(10.f*(float)M_PI*(i/float(NUM_INSTANCE_SPHERE_X)))*cosf(10.f*(float)M_PI*(j/float(NUM_INSTANCE_SPHERE_Y)))*cosf(10.f*(float)M_PI*(k/float(NUM_INSTANCE_SPHERE_Z)));
                scaMapping[i+j*NUM_INSTANCE_SPHERE_X+k*NUM_INSTANCE_SPHERE_X*NUM_INSTANCE_SPHERE_Y].setValue(s, s, s);
              }
            }
          }
        }
        vertexParameters->value.setValue(bufferValues);
      }
      vertexParameters->name = SoInstanceParameter::getPredefinedParameterName(SoInstanceParameter::SCALE);
      multiInstanceGroup->parameters.set1Value(1, vertexParameters);
    }

    // rotation attribute
    {
      SoInstanceParameter* vertexParameters = new SoInstanceParameter;
      vertexParameters->components = 4;
      vertexParameters->type = SbDataType::FLOAT;
      {
        SoGpuBufferObject* bufferValues = new SoGpuBufferObject;
        bufferValues->setSize(NUM_INSTANCE_SPHERE*sizeof(SbVec4f));
        {
          BufferObjectMapper<SbVec4f> rotMapping(bufferValues, SoBufferObject::SET);
          for (int k = 0; k < NUM_INSTANCE_SPHERE_Z; k++)
            for (int j = 0; j < NUM_INSTANCE_SPHERE_Y; j++)
              for (int i = 0; i < NUM_INSTANCE_SPHERE_X; i++)
                rotMapping[i+j*NUM_INSTANCE_SPHERE_X+k*NUM_INSTANCE_SPHERE_X*NUM_INSTANCE_SPHERE_Y].setValue(0.f, 0.f, 0.f, 1.f);
        }
        vertexParameters->value.setValue(bufferValues);
      }
      vertexParameters->name = SoInstanceParameter::getPredefinedParameterName(SoInstanceParameter::ROTATION);
      multiInstanceGroup->parameters.set1Value(2, vertexParameters);
    }

    // add the specific instanced shape
    {
      SoAlgebraicSphere* qShape = new SoAlgebraicSphere;
      qShape->radius.connectFrom(&sRadius->value);

      std::string tempStr = s_resourceRootDir + "shaders/oivASSlotColorCustomColormap_vert.glsl";
      SoVertexShader* vs = new SoVertexShader();
      vs->sourceProgram.setValue(tempStr);
      SoFragmentShader* fs = new SoFragmentShader();
      tempStr = s_resourceRootDir + "shaders/oivASSlotColorCustomColormap_frag.glsl";
      fs->sourceProgram.setValue(tempStr);

      qShape->shaderSlots.set1Value(SoAlgebraicShape::VERTEX_SHADER_ENTRY, vs);
      qShape->shaderSlots.set1Value(SoAlgebraicShape::COMPUTE_COLOR, fs);

      // shader parameters
      fs->addShaderParameter1i("colorMap", 1);

      SoShaderParameter1f* sp1f = vs->addShaderParameter1f("cmMin", 0.f);
      sp1f->value.connectFrom(&cMin->value);

      sp1f = vs->addShaderParameter1f("cmMax", 1.f);
      sp1f->value.connectFrom(&cMax->value);

      multiInstanceGroup->addChild(qShape);
    }
  }

  SoMaterial* mat = new SoMaterial;
  mat->diffuseColor.setValue(0.5f, 0.5f, 0.5f);
  mat->specularColor.setValue(0.8f, 0.5f, 0.5f);
  mat->shininess.set1Value(0, 0.25f);
  newScene->addChild(mat);

  // create cylinders along X, Y and Z
  {
    const SbVec3i32 numInstanceX (NUM_INSTANCE_SPHERE_X-1, NUM_INSTANCE_SPHERE_X, NUM_INSTANCE_SPHERE_X);
    const SbVec3i32 numInstanceY (NUM_INSTANCE_SPHERE_Y, NUM_INSTANCE_SPHERE_Y-1, NUM_INSTANCE_SPHERE_Y);
    const SbVec3i32 numInstanceZ (NUM_INSTANCE_SPHERE_Z, NUM_INSTANCE_SPHERE_Z, NUM_INSTANCE_SPHERE_Z-1);
    const SbVec3i32 numInstance ( numInstanceX[0]*numInstanceY[0]*numInstanceZ[0],
                                  numInstanceX[1]*numInstanceY[1]*numInstanceZ[1],
                                  numInstanceX[2]*numInstanceY[2]*numInstanceZ[2] )    ;

    // Create SoMultipleInstance group node where to add our geometry
    SoMultipleInstance* multiInstanceGroup = new SoMultipleInstance;
    multiInstanceGroup->numInstances = numInstance[0]+numInstance[1]+numInstance[2];
    newScene->addChild(multiInstanceGroup);

    // translation attribute
    {
      SoInstanceParameter* vertexParameters = new SoInstanceParameter;
      vertexParameters->components = 3;
      vertexParameters->type = SbDataType::FLOAT;
      {
        SoGpuBufferObject* bufferValues = new SoGpuBufferObject;
        bufferValues->setSize((numInstance[0]+numInstance[1]+numInstance[2])*sizeof(SbVec3f));
        {
          BufferObjectMapper<SbVec3f> traMapping(bufferValues, SoBufferObject::SET);
          int decal = 0;
          for ( int d = 0; d < 3; ++d ) {
            for (int k = 0; k < numInstanceZ[d]; k++) {
              for (int j = 0; j < numInstanceY[d]; j++) {
                for (int i = 0; i < numInstanceX[d]; i++) {
                  SbVec3f tra (i*4.f, j*4.f, k*4.f);
                  tra[d] += 2.f;
                  traMapping[decal+i+j*numInstanceX[d]+k*numInstanceX[d]*numInstanceY[d]].setValue(tra[0], tra[1], tra[2]);

                }
              }
            }
            decal += numInstance[d];
          }
        }

        vertexParameters->value.setValue(bufferValues);
      }
      vertexParameters->name = SoInstanceParameter::getPredefinedParameterName(SoInstanceParameter::TRANSLATION);
      multiInstanceGroup->parameters.set1Value(0, vertexParameters);
    }

    // scale attribute
    {
      SoInstanceParameter* vertexParameters = new SoInstanceParameter;
      vertexParameters->components = 3;
      vertexParameters->type = SbDataType::FLOAT;
      {
        SoGpuBufferObject* bufferValues = new SoGpuBufferObject;
        bufferValues->setSize(sizeof(SbVec3f));
        float* bufferData = (float*) bufferValues->map(SoBufferObject::SET);
        bufferData[0] = bufferData[2] = 0.25f; bufferData[1] = 1.9f;
        bufferValues->unmap();
        vertexParameters->value.setValue(bufferValues);
      }
      vertexParameters->name = SoInstanceParameter::getPredefinedParameterName(SoInstanceParameter::SCALE);
      vertexParameters->divisor.setValue(numInstance[0]+numInstance[1]+numInstance[2]);
      multiInstanceGroup->parameters.set1Value(1, vertexParameters);
    }

    // rotation attribute
    {
      SoInstanceParameter* vertexParameters = new SoInstanceParameter;
      vertexParameters->components = 4;
      vertexParameters->type = SbDataType::FLOAT;
      {
        SoGpuBufferObject* bufferValues = new SoGpuBufferObject;
        bufferValues->setSize(3*sizeof(SbVec4f));
        float* bufferData = (float*) bufferValues->map(SoBufferObject::SET);
        const float hsqrt2 = 0.5f*sqrt(2.f);
        bufferData[0] = bufferData[1] = 0.f; bufferData[2] = bufferData[3] = hsqrt2;
        bufferData[4] = bufferData[5] = bufferData[6] = 0.f; bufferData[7] = 1.f;
        bufferData[9] = bufferData[10] = 0.f; bufferData[8] = bufferData[11] = hsqrt2;
        bufferValues->unmap();
        vertexParameters->value.setValue(bufferValues);
      }
      vertexParameters->name = SoInstanceParameter::getPredefinedParameterName(SoInstanceParameter::ROTATION);
      vertexParameters->divisor.setValue(numInstance[0]);
      multiInstanceGroup->parameters.set1Value(2, vertexParameters);
    }

    // add the specific instanced shape
    {
      SoAlgebraicCylinder* rcs = new SoAlgebraicCylinder;
      multiInstanceGroup->addChild(rcs);
    }
  }

  //replace the original scene graph by the global collected shape
  root->addChild(newScene.ptr());
}


int
main ( int /*argc*/, char **argv )
{
  SoWidget window = SoXt::init(argv[0]);
  SoDialogViz::init();

  s_resourceRootDir = "$OIVHOME/examples/source/Inventor/Features/MultiInstancing/AlgebraicShapes/";

  {
    SoInput input;
    std::string tempStr = s_resourceRootDir + "Instancing.iv";
    input.openFile(tempStr);
    SoRef<SoSeparator> iv = SoDB::readAll(&input);

    if (iv.ptr() == NULL)
      exit(EXIT_FAILURE);

    SoTopLevelDialog* gui = static_cast<SoTopLevelDialog*>(iv->getByName("GUI"));  

    SoDialogRealSlider* sRadius = static_cast<SoDialogRealSlider*>(iv->getByName("SphereRadius"));
    SoDialogRealSlider* cmMin = static_cast<SoDialogRealSlider*>(iv->getByName("ColorMapMin"));
    SoDialogRealSlider* cmMax = static_cast<SoDialogRealSlider*>(iv->getByName("ColorMapMax"));

    gui->buildDialog(window, true);

    SoSeparator* scene = static_cast<SoSeparator*>(iv->getByName("SCENE"));
    scene->addChild( new SoGradientBackground );

    SoWidget viewerWidget =  static_cast<SoDialogCustom*>(iv->getByName("VIEWER"))->getWidget();
    SoXtExaminerViewer* viewer = new SoXtExaminerViewer(viewerWidget);
    viewer->setAntialiasing(1.f);
    viewer->show();
    SoXt::show(window);

    // Must be done here to have a valid context
    viewer->bindNormalContext();
    buildSG(scene, sRadius, cmMin, cmMax);
    viewer->unbindNormalContext();
    viewer->setSceneGraph(scene);
    viewer->viewAll();

    SoXt::mainLoop();

    delete viewer;
  }

  SoDialogViz::finish();
  SoXt::finish();

  return EXIT_SUCCESS; 
}
