/*=======================================================================
** VSG_COPYRIGHT_TAG
**=======================================================================*/

#include <Inventor/helpers/SbFileHelper.h>
#include <Inventor/image/SoHDRImageRW.h>
#include <Inventor/image/SoJPEGImageRW.h>
#include <Inventor/image/SoPNGImageRW.h>
#include <Inventor/image/SoRasterImageFile.h>
#include <Inventor/nodes/SoCube.h>
#include <Inventor/nodes/SoGradientBackground.h>
#include <Inventor/nodes/SoRenderToTarget.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoSphere.h>
#include <Inventor/nodes/SoSwitch.h>
#include <Inventor/nodes/SoTexture2.h>
#include <Inventor/nodes/SoTexture3.h>
#include <Inventor/nodes/SoTextureUnit.h>
#include <Inventor/nodes/SoShaderProgram.h>
#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>

#include <DialogViz/SoDialogVizAll.h>

SoRenderToTarget*    g_renderToTarget = NULL;
SoShaderParameter1i* g_rttSize = NULL;
SoTopLevelDialog*    g_topLevelDialog = NULL;

// specify texture internal format: 0 for RGBA8, 1 for RGBA_FLOAT32
#define USE_FLOAT_COLORBUFFER 0

// specify the layout to use in SoTexture3: SoTexture3::VOLUME for Volume, SoTexture3::ARRAY for Array
#define TEXTURE_LAYOUT SoTexture3::ARRAY
//#define TEXTURE_LAYOUT SoTexture3::VOLUME


// default size for render to target viewport
#define DEFAULT_SIZE 256


class MyAuditorClass : public SoDialogAuditor
{
  void
  dialogIntegerSlider( SoDialogIntegerSlider* slider )
  {
    if (slider->auditorID.getValue() == SbString("targetSize"))
    {
      int value = slider->value.getValue();
      g_renderToTarget->size = SbVec2i32(value, value);
      g_rttSize->value = value;
    }
  }
};


Widget
buildInterface(Widget window)
{
   g_topLevelDialog = (SoTopLevelDialog*) SoDialogViz::loadFromFile(SbFileHelper::expandString("$OIVHOME/examples/source/Inventor/Features/MultipleRenderToTexture3D/MultipleRenderToTexture3D.iv"));
  
  if (g_topLevelDialog) { 
    MyAuditorClass *myAuditor = new MyAuditorClass;
    g_topLevelDialog->addAuditor( myAuditor );

    SoDialogCustom *customNode = (SoDialogCustom *)g_topLevelDialog->searchForAuditorId(SbString("Viewer"));

    g_topLevelDialog->buildDialog( window, TRUE );
    g_topLevelDialog->show();

    return customNode ? customNode->getWidget() : window;
  }

  return NULL;
}

int main(int /*argc*/, char** argv)
{
  Widget mainWindow = SoXt::init(argv[0]); // pass the app name
  SoDialogViz::init();

  if (mainWindow == NULL) 
    exit(1);

  if ( !SoRenderToTarget::isSupported() ) 
  {
    fprintf(stderr, "This demo cannot be run because SoRenderToTarget is not available on this platforms!\n");
    exit( 1 );
  }

  // set up viewer
  Widget parent = buildInterface(mainWindow);
  SoXtExaminerViewer* mainViewer = new SoXtExaminerViewer(parent);
  mainViewer->setAntialiasing(1.f);

  // initialize texture target
  SoTexture3* rgbaTexture = new SoTexture3;
  rgbaTexture->layout.setValue(TEXTURE_LAYOUT);

#if USE_FLOAT_COLORBUFFER
  rgbaTexture->internalFormat = SoTexture::RGBA_FLOAT32;
#else
  rgbaTexture->internalFormat = SoTexture::RGBA8;
#endif

  // allocate texture memory
  {
    SbVec3s size (DEFAULT_SIZE, DEFAULT_SIZE, 6);
    unsigned char* buf = new unsigned char[DEFAULT_SIZE*DEFAULT_SIZE*6*4];
    rgbaTexture->images.setValue(size, 4, buf, SoSFImage3::NO_COPY_AND_DELETE);
  }

  // initialize render to target node
  g_renderToTarget = new SoRenderToTarget;
  g_renderToTarget->size.setValue(SbVec2i32(DEFAULT_SIZE, DEFAULT_SIZE));

  // set targets, i.e. textures in which we want to render each target
  // here, the same texture, a SoTexture3, is attached to all targets
  g_renderToTarget->targets.set1Value(SoRenderToTarget::COLOR0, rgbaTexture);
  g_renderToTarget->targets.set1Value(SoRenderToTarget::COLOR1, rgbaTexture);
  g_renderToTarget->targets.set1Value(SoRenderToTarget::COLOR2, rgbaTexture);
  g_renderToTarget->targets.set1Value(SoRenderToTarget::COLOR3, rgbaTexture);
  g_renderToTarget->targets.set1Value(SoRenderToTarget::COLOR4, rgbaTexture);
  g_renderToTarget->targets.set1Value(SoRenderToTarget::COLOR5, rgbaTexture);

  // since the same texture is attached for all render target, we specify
  // the layer in which each target must write into
  g_renderToTarget->layers.set1Value(SoRenderToTarget::COLOR0, 0);
  g_renderToTarget->layers.set1Value(SoRenderToTarget::COLOR1, 1);
  g_renderToTarget->layers.set1Value(SoRenderToTarget::COLOR2, 2);
  g_renderToTarget->layers.set1Value(SoRenderToTarget::COLOR3, 3);
  g_renderToTarget->layers.set1Value(SoRenderToTarget::COLOR4, 4);
  g_renderToTarget->layers.set1Value(SoRenderToTarget::COLOR5, 5);

  // build the scene for offline rendering
  SoGroup* rttScene = new SoGroup;
  {
    SoShaderProgram* prog = new SoShaderProgram;
    prog->setVertexShader(0, "$OIVHOME/examples/source/Inventor/Features/MultipleRenderToTexture3D/shaders/RTT_vert.glsl");
    prog->setFragmentShader(1, "$OIVHOME/examples/source/Inventor/Features/MultipleRenderToTexture3D/shaders/RTT_frag.glsl");
    rttScene->addChild(prog);

    g_rttSize = new SoShaderParameter1i;
    g_rttSize->name.setValue("rttSize");
    g_rttSize->value = DEFAULT_SIZE;
    rttScene->addChild(g_rttSize);

    // just a quad in this scene to draw on it
    SoGradientBackground* bgrd = new SoGradientBackground;
    bgrd->color0 = SbVec3f(0.f, 0.f, 0.f);
    bgrd->color1 = SbVec3f(0.f, 0.f, 0.f);
    rttScene->addChild(bgrd);
  }
  g_renderToTarget->addChild(rttScene);

  // build the scene for online rendering
  SoSeparator* scene = new SoSeparator();
  {
    int textureUnit = 0;
    SoTextureUnit* texUnit = new SoTextureUnit;
    texUnit->unit.setValue(textureUnit);

    scene->addChild(texUnit);
    scene->addChild(rgbaTexture);

    SoShaderProgram* prog = new SoShaderProgram;

    prog->setVertexShader(0, "$OIVHOME/examples/source/Inventor/Features/MultipleRenderToTexture3D/shaders/Scene_vert.glsl");

    SoFragmentShader* frag;
    if (TEXTURE_LAYOUT == SoTexture3::VOLUME)
    {
      frag = prog->setFragmentShader(1, "$OIVHOME/examples/source/Inventor/Features/MultipleRenderToTexture3D/shaders/Scene_VOLUME_frag.glsl");
      frag->addShaderParameter1i("rgbaTexture3d", textureUnit);
    }
    else // (TEXTURE_LAYOUT == SoTexture3::ARRAY)
    {
      frag = prog->setFragmentShader(1, "$OIVHOME/examples/source/Inventor/Features/MultipleRenderToTexture3D/shaders/Scene_ARRAY_frag.glsl");
      frag->addShaderParameter1i("rgbaTexture2dArray", textureUnit);
    }

    SoShaderParameter1i* texLayout = frag->addShaderParameter1i("tex_layout_type", TEXTURE_LAYOUT);
    texLayout->value.connectFrom(&rgbaTexture->layout);
    
    scene->addChild(prog);

    scene->addChild(new SoCube);
  }

  // build the whole scene graph
  SoSeparator* root = new SoSeparator;
  root->ref();
  root->addChild(new SoGradientBackground);

  root->addChild(g_renderToTarget);

  root->addChild(scene);

  mainViewer->setSceneGraph(root);
  mainViewer->show();        
  
  SoXt::show(mainWindow);  // Display main window   
  
  mainViewer->viewAll();

  SoXt::mainLoop();

  root->unref();
  delete mainViewer;
  g_topLevelDialog->close();

  SoDialogViz::finish();
  SoXt::finish();

  return 0;
}


