#version 410 core

//!oiv_include <Inventor/oivShaderState.h>


//!oiv_include <Inventor/oivDepthPeeling_frag.h>

uniform sampler2DArray rgbaTexture2dArray;


in vec3 vPos;

bool
isAlmostEqual ( in float a, in float b )
{
  return (abs(a - b) < 1e-2);
}

void
main ()
{
  int face = 0;
  vec2 texCoord = vec2(0.0);

  if ( isAlmostEqual(vPos.z, 1.0) )
  {
    face = 0;
    texCoord = vPos.xy;
  }
  else if ( isAlmostEqual(vPos.y, 1.0) )
  {
    face = 1;
    texCoord = vPos.xz;
  }
  else if ( isAlmostEqual(vPos.x, 1.0) )
  {
    face = 2;
    texCoord = vPos.yz;
  }
  else if ( isAlmostEqual(vPos.z, -1.0) )
  {
    face = 3;
    texCoord = vPos.xy;
  }
  else if ( isAlmostEqual(vPos.y, -1.0) )
  {
    face = 4;
    texCoord = vPos.xz;
  }
  else // if ( isAlmostEqual(vPos.x, -1.0) )
  {
    face = 5;
    texCoord = vPos.yz;
  }

  if (OivDepthPeel(gl_FragCoord.xyz))
  {
    vec4 fragColor;
    if ( any(greaterThanEqual(abs(texCoord), vec2(0.98))) )
    {
      fragColor = vec4(0.0, 0.0, 0.0, 1.0);
    }
    else
    {
      texCoord *= 0.5;
      texCoord += 0.5;

      fragColor = texture(rgbaTexture2dArray, vec3(texCoord, face));
    }
    OivDepthPeelingOutputColor(fragColor);
  }
}
