#pragma once

#include <Inventor/Xt/viewers/SoXtViewer.h>
#include <Inventor/components/stereo/SoBaseStereo.h>
#include <Inventor/components/stereo/SoStereoViewer.h>

class SoNode;
class SoCamera;
class SoOffscreenRenderArea;

/////////////////////////////////////////////////////////////////////
//
// OffscreenStereo is a Stereo Viewer, menaing that is has the
// capability of using a stereo technique to render in stereo a
// scene.
//
/////////////////////////////////////////////////////////////////////

typedef void OutputCB( SoOffscreenRenderArea* offscreenR, void* userData );

class OffscreenStereo : public SoStereoViewer
{
public:
  // default width and height = 200
  OffscreenStereo( SoNode* myScene );
  OffscreenStereo( SoNode* myScene, int width, int height );
  ~OffscreenStereo();

  // stereo viewer interface

  virtual void setStereoActive( SbBool /* active*/ )
  { /* no need */
  }
  virtual SbBool
  isStereoActive()
  {
    return TRUE;
  }

  virtual void actualRendering();

  virtual SoCamera* getViewerCamera();

  virtual void
  adjustClippingPlanes()
  { /* no need */
  }

  virtual const SbVec2s&
  getSize()
  {
    return size;
  }
  virtual const SbVec2s&
  getTopLeft()
  {
    return topLeft;
  }
  virtual const SbVec2s&
  getBottomRight()
  {
    return bottomRight;
  }

  virtual SbBool
  isViewerDoubleBuffer()
  {
    return TRUE;
  } // whatever

  virtual void
  setStereoViewType( SoBaseStereo* svt )
  {
    stereoViewType = svt;
  }
  virtual SoBaseStereo*
  getStereoViewType()
  {
    return stereoViewType;
  }

  virtual void
  reverseStereoView( SbBool reverse )
  {
    stereoViewType->reverseStereoView( reverse );
  }
  virtual SbBool
  isStereoViewReversed()
  {
    return stereoViewType->isStereoViewReversed();
  }

  virtual void
  setStereoOffset( float stereoOffset )
  {
    offset = stereoOffset;
  }
  virtual float
  getStereoOffset()
  {
    return offset;
  }

  virtual void
  setStereoBalance( float stereoBalance, SbBool nearFrac = false )
  {
    balance = stereoBalance;
    balanceNearFrac = nearFrac;
  }
  virtual float
  getStereoBalance()
  {
    return balance;
  }
  virtual SbBool
  isStereoBalanceNearFrac()
  {
    return balanceNearFrac;
  }

  virtual void setViewport( short left, short bottom, short width, short height );
  virtual void getViewport( short& left, short& bottom, short& width, short& height );

  virtual HDC
  getCurrentDC()
  {
    return NULL;
  }

  // interface specific to offscreen stereo

  void
  setCallback( OutputCB* cb, void* userData )
  {
    outputCB = cb;
    outputCBud = userData;
  }

  void renderSceneInStereo();

  virtual void*
  getViewer()
  {
    return m_viewer;
  }

  virtual SoGLContext*
  getViewerContext()
  {
    return m_viewer->getNormalSoContext();
  }

  virtual SoSceneManager*
  getViewerSceneManager()
  {
    return m_viewer->getSceneManager();
  }

  SoINTERNAL public : virtual void
                      setViewer( SoXtViewer* viewer )
  {
    m_viewer = viewer;
  }

private:
  SoXtViewer* m_viewer;
  SbVec2s size, topLeft, bottomRight;
  SoNode* scene;
  SoBaseStereo* stereoViewType;
  SoCamera* camera;
  OutputCB* outputCB;
  void* outputCBud;
  float offset, balance;
  SbBool balanceNearFrac;
};

/////////////////////////////////////////////////////////////////////
//
// SimpleStereo is the simplest stereo possible: it sets the camera
// in stereo mode and requests a rendering for each eye. No specific
// operation is then done on each eye since what is wanted is a
// complete raster image for each eye.
//
/////////////////////////////////////////////////////////////////////

class SimpleStereo : public SoBaseStereo
{
public:
  SimpleStereo() { reverse = FALSE; }
  ~SimpleStereo() {}

  virtual void
  reverseStereoView( SbBool my_reverse )
  {
    this->reverse = my_reverse;
  }
  virtual SbBool
  isStereoViewReversed()
  {
    return reverse;
  }

  virtual void renderStereoView();

  virtual StereoViewType
  getStereoViewType()
  {
    return RAW_STEREO;
  } // whatever
  virtual SbBool
  canClearBeforeRender()
  {
    return TRUE;
  } // whatever

  virtual void
  renderMPStereoView()
  { /* no need */
  }

  virtual SbBool
  requireHardware()
  {
    return FALSE;
  }
  virtual void
  clearStereo()
  { /* nothing to do */
  }
  virtual void
  doLeftEyeSettings()
  { /* nothing to do */
  }
  virtual void
  doRightEyeSettings()
  { /* nothing to do */
  }
  virtual void
  doMonoscopicSettings()
  { /* nothing to do */
  }

private:
  SbBool reverse;
};
