
#include <Inventor/ViewerComponents/Qt/QtHelper.h>
#include <Inventor/ViewerComponents/Qt/RenderAreaOrbiter.h>

#include <QApplication>
#include <QCheckBox>
#include <QDebug>
#include <QGroupBox>
#include <QLabel>
#include <QMainWindow>
#include <QRadioButton>
#include <QSlider>
#include <QVBoxLayout>
#include <QWidget>

#include <Inventor/SoDB.h>
#include <Inventor/SoInteraction.h>
#include <Inventor/nodes/SoSelection.h>
#include <Inventor/actions/SoHaloHighlightRenderAction.h>

#include <SceneOverlayPanels.h>

int
main( int argc, char** argv )
{
  QtHelper::addPlatformPluginsPath();

  QApplication app( argc, argv );

  QMainWindow* window = new QMainWindow;
  window->setWindowTitle( "OverlayPanels" );
  window->resize( 1000, 800 );
  window->show();

  SoDB::init();
  SoInteraction::init();

  auto scene = new SceneOverlayPanels;
  SoSelection *root = scene->getSceneGraph();
  // Redraw scene on selection changed
  root->addStartCallback( []( void* /*data*/, SoSelection* selection ) { selection->touch(); } );

  // Setup widgets layout
  QWidget* centralWidget = new QWidget( window );
  QVBoxLayout* centralLayout = new QVBoxLayout;
  centralLayout->setContentsMargins( 0, 0, 0, 0 );
  centralLayout->setSpacing( 0 );
  centralWidget->setLayout( centralLayout );

  // Setup Render Area
  RenderAreaOrbiter* renderArea = new RenderAreaOrbiter( window );
  renderArea->setTransparencyType( SoGLRenderAction::SORTED_PIXEL );
  auto highlightAction = new SoHaloHighlightRenderAction;
  highlightAction->setHaloAlwaysVisible( true );
  renderArea->setGLRenderAction( highlightAction );
  renderArea->setSceneGraph( root );
  renderArea->viewAll( SbViewportRegion() );
  centralLayout->addWidget( renderArea->getContainerWidget() );  

  window->setCentralWidget( centralWidget );
  window->show();

  app.exec();

  delete window;

  SoDB::finish();

  return EXIT_SUCCESS;
}
