
#include <Inventor/misc/SoRef.h>

class SoSelection;
class SoMaterial;
class SoFaceSet;
class SoLineSet;
class SoTransform;

class SceneOverlayPanels
{
public:
  SoSelection* getSceneGraph();

private:
  void generatedProfile();

  SoMaterial* getRandomMat();

  SoFaceSet* getFence( int overlayIndex, int panelIndex, float bottom, float range );

  SoLineSet* getFenceLine( int overlayIndex, int panelIndex, float bottom, float range );

  SoTransform* getPanelNamePosition( int panelIndex, float bottom, float range );

  SoSelection* getMultiPanelScene();

  SoRef<SoSelection> m_scene;
  std::vector<SbVec3f> m_profile;
};
