/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2020 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : P. ESTRADE (Dec 1999)
**=======================================================================*/

/*
 * Description : This program is a demonstration for Patterns.
 *               It use DialogMaster and PlotMaster. It load a pattern file.
 *               You can create CGM and PostScript files. You can modify the 
 *               color of the right pattern.
 *
 *============================================================================*/

#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/Xt/SoXtMaterialEditor.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoPerspectiveCamera.h>
#include <Inventor/nodes/SoPattern.h>
#include <Inventor/nodes/SoMaterial.h>
#include <Inventor/nodes/SoCoordinate3.h>
#include <Inventor/nodes/SoFaceSet.h>
#include <Inventor/nodes/SoVertexProperty.h>
#include <Inventor/nodes/SoTransform.h>
#include <Inventor/nodes/SoCube.h>

#include <HardCopy/SoVectorizePSAction.h>
#include <HardCopy/SoVectorizeCGMAction.h>
#include <DialogViz/SoDialogVizAll.h>

#include <Inventor/helpers/SbFileHelper.h>


static unsigned char pattBuff[128] = {
  0xFF, 0x00, 0xFF, 0x00, 
  0x30, 0x00, 0x30, 0x00, 
  0x18, 0x00, 0x18, 0x00, 
  0x0C, 0x00, 0x0C, 0x00, 
  0xFF, 0x00, 0xFF, 0x00, 
  0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 
  0x00, 0xFF, 0x00, 0xFF, 
  0x00, 0x30, 0x00, 0x30, 
  0x00, 0x18, 0x00, 0x18, 
  0x00, 0x0C, 0x00, 0x0C, 
  0x00, 0xFF, 0x00, 0xFF, 
  0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 
  0xFF, 0x00, 0xFF, 0x00, 
  0x30, 0x00, 0x30, 0x00, 
  0x18, 0x00, 0x18, 0x00, 
  0x0C, 0x00, 0x0C, 0x00, 
  0xFF, 0x00, 0xFF, 0x00, 
  0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 
  0x00, 0xFF, 0x00, 0xFF, 
  0x00, 0x30, 0x00, 0x30, 
  0x00, 0x18, 0x00, 0x18, 
  0x00, 0x0C, 0x00, 0x0C, 
  0x00, 0xFF, 0x00, 0xFF, 
  0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00
};

// Vertices for faceSets.
static float vertices[6][3] = { 
  {-1.0, 1.0, 0.0}, 
  { 0.0, 0.0, 0.0}, 
  { 0.0, 1.0, 0.0}, 
  {-1.0, 0.0, 0.0}, 
  { 0.0, 0.0, 0.0}, 
  {-1.0, 1.0, 0.0}
};

// Number of vertices.
static int32_t numVertices[2] = { 3, 3 };

SoXtMaterialEditor *myMaterialEditor;
SoPattern *myRightPattern;
SoSeparator *root;

class ColorAuditor : public SoDialogPushButtonAuditor
{
public:
  static SbBool s_flag;
  void dialogPushButton( SoDialogPushButton* /*cpt*/ )
  {
    if ( !s_flag )
      myMaterialEditor->show();
    else
      myMaterialEditor->hide();
    s_flag = !s_flag;
  }
};
SbBool ColorAuditor::s_flag = FALSE;

class PatternChoiceAuditor : public SoDialogChoiceAuditor
{
public:
  void dialogChoice( SoDialogChoice* cpt )
  {
    switch ( cpt->selectedItem.getValue() )
    {
    case 0:
      myRightPattern->category.setValue( "GEOLOGY" );
      myRightPattern->name.setValue( "PATTERN N2" );
      break;
    case 1:
      myRightPattern->category.setValue( "GEOLOGY" );
      myRightPattern->name.setValue( "PATTERN N3" );
      break;
    case 2:
      myRightPattern->category.setValue( "GEOLOGY" );
      myRightPattern->name.setValue( "PATTERN N4" );
      break;
    case 3:
      myRightPattern->category.setValue( "GEOLOGY" );
      myRightPattern->name.setValue( "PATTERN N5" );
      break;
    case 4:
      myRightPattern->category.setValue( "GEOLOGY" );
      myRightPattern->name.setValue( "PATTERN N6" );
      break;
    case 5:
      myRightPattern->category.setValue( "GEOLOGY" );
      myRightPattern->name.setValue( "TGS PATTERN" );
      break;
    case 6:
      myRightPattern->category.setValue( "GEOLOGY 2" );
      myRightPattern->name.setValue( "PATTERN BUFF" );
      break;
    }
  }
};

class PrintPSAuditor : public SoDialogPushButtonAuditor
{
public:
  void dialogPushButton( SoDialogPushButton* /*cpt*/ )
  {
    SoVectorizePSAction vectPSAction;
    vectPSAction.getPSVectorOutput()->openFile( "file.ps" );
    printf( "Begin Printing...\n" );
    vectPSAction.apply( root );
    printf( "End\n\n" );
    vectPSAction.getPSVectorOutput()->closeFile();
  }
};

class PrintCGMAuditor : public SoDialogPushButtonAuditor
{
public:
  void dialogPushButton( SoDialogPushButton* /*cpt*/ )
  {
    SoVectorizeCGMAction vectCGMAction;
    vectCGMAction.getCGMVectorOutput()->openFile( "file.cgm" );
    printf( "Begin Printing...\n" );
    vectCGMAction.getCGMVectorOutput()->setBinary( TRUE );
    vectCGMAction.apply( root );
    printf( "End\n\n" );
    vectCGMAction.getCGMVectorOutput()->closeFile();
  }
};

// Create dialog
static void
buildDialog( SoTopLevelDialog* dialog, Widget root, SbString* names, int numNames )
{
  dialog->label.setValue( "Control" );

  SoDialogLabel* label = new SoDialogLabel;
  label->label.setValue( "Test Program for Pattern" );
  dialog->addChild( label );

  SoDialogPushButton* color = new SoDialogPushButton;
  color->label.setValue( "Select the color of the pattern :" );
  color->buttonLabel.setValue( "Color" );
  color->addAuditor( new ColorAuditor );
  dialog->addChild( color );

  SoDialogComboBox* patternChoice = new SoDialogComboBox;
  patternChoice->label.setValue( "Pattern choice :" );
  patternChoice->items.setValues( 0, numNames, names );
  patternChoice->addAuditor( new PatternChoiceAuditor );
  dialog->addChild( patternChoice );

  SoDialogPushButton* printPS = new SoDialogPushButton;
  printPS->label.setValue( "Create a PostScript file :" );
  printPS->buttonLabel.setValue( "Print PS" );
  printPS->addAuditor( new PrintPSAuditor );
  dialog->addChild( printPS );

  SoDialogPushButton* printCGM = new SoDialogPushButton;
  printCGM->label.setValue( "Create a CGM file :" );
  printCGM->buttonLabel.setValue( "Print CGM" );
  printCGM->addAuditor( new PrintCGMAuditor );
  dialog->addChild( printCGM );

  dialog->buildDialog( root );
}

int
main(int argc, char **argv) 
{
  SbString filepath = SbFileHelper::expandString("$OIVHOME/data/patterns/geology.pat");
  SbString filterNames[2];
  int numFilters;
  
  Widget toplevel = SoXt::init(argv[0]);
  if (!toplevel)
    exit(-1);

  SoDialogViz::init();

  SoVectorizePSAction::initClass();
  SoVectorizeCGMAction::initClass();

  // Material Editor.
  myMaterialEditor = new SoXtMaterialEditor;
  root = new SoSeparator;
  root->ref();

  SoPerspectiveCamera *myCamera = new SoPerspectiveCamera;
  root->addChild(myCamera);

  // I want all the pattern of the file but not the first one !
  filterNames[0] = "PATTERN N1";
  numFilters = 1;
  if( argc > 1 )
    SoPattern::loadPatterns(argv[1], numFilters, filterNames, SoPattern::EXCLUSIVE_FILTER);
  else
    SoPattern::loadPatterns(filepath.getString(), numFilters, filterNames, SoPattern::EXCLUSIVE_FILTER);

  //============================ Left FaceSet ===============================
  SoSeparator *leftSep = new SoSeparator;
  root->addChild(leftSep);

  SoTransform *myTransfo = new SoTransform;
  leftSep->addChild(myTransfo);
  myTransfo->translation.setValue(-1., 0., 0.);

  SoMaterial *myLeftMaterial = new SoMaterial;
  leftSep->addChild(myLeftMaterial);
  myLeftMaterial->diffuseColor.setValue(0., 0., 1.);
  
  // Pattern.
  SoPattern *myLeftPattern = new SoPattern;
  leftSep->addChild(myLeftPattern);
  myLeftPattern->category.setValue("GEOLOGY");
  myLeftPattern->name.setValue("PATTERN N4");

  SoVertexProperty *myLeftVertexProperty = new SoVertexProperty();
  myLeftVertexProperty->vertex.setValues(0, 6, vertices);

  SoFaceSet *myLeftFaceSet = new SoFaceSet;
  myLeftFaceSet->vertexProperty.setValue((SoNode*)myLeftVertexProperty);
  myLeftFaceSet->numVertices.setValues(0, 2, numVertices);
  leftSep->addChild(myLeftFaceSet);

  //========================== Right FaceSet ==============================
  SoSeparator *rightSep = new SoSeparator;
  root->addChild(rightSep);
  
  SoMaterial *myRightMaterial = new SoMaterial;
  rightSep->addChild(myRightMaterial);
  myRightMaterial->diffuseColor.setValue(1., 0., 0.);
  myMaterialEditor->attach(myRightMaterial);

  // The Pattern.
  SoPattern::addPattern("GEOLOGY 2", "PATTERN BUFF", pattBuff);
  myRightPattern = new SoPattern;
  rightSep->addChild(myRightPattern);
  // The pattern will be given next, for the init.

  SoVertexProperty *myRightVertexProperty = new SoVertexProperty();
  myRightVertexProperty->vertex.setValues(0, 6, vertices);

  SoFaceSet *myRightFaceSet = new SoFaceSet;
  myRightFaceSet->vertexProperty.setValue((SoNode*)myRightVertexProperty);
  myRightFaceSet->numVertices.setValues(0, 2, numVertices);
  rightSep->addChild(myRightFaceSet);
  
  //=========================================================================

  SoXtExaminerViewer *myViewer = new SoXtExaminerViewer(toplevel);
  myViewer->setSceneGraph(root);
  myViewer->setTitle("Pattern Test");
  myCamera->viewAll(root, myViewer->getViewportRegion());

  myViewer->show();


  // print all pattern names used in this test.
  int number;
  int i;
  SbString *names;
  SoPattern::getPatternNames(number, names);
  printf("The Following list of pattern is used in the test : \n");
  for(i = 0; i < number; i++)
    printf("                                %s\n", names[i].getString());

  // This to init the right pattern for the first time.
  if(i==1) {
    printf("The default pattern file has not been found or\nthe argument pattern path file is not valid !\n\a");
    myRightPattern->category.setValue("GEOLOGY 2");
  } else
    myRightPattern->category.setValue("GEOLOGY");
  myRightPattern->name.setValue(names[0].getString());

  SoRef<SoTopLevelDialog> dialog = new SoTopLevelDialog;
  buildDialog( dialog.ptr(), toplevel, names, number );
  dialog->show();

  delete []names;

  SoXt::show(toplevel);
  SoXt::mainLoop();

  dialog = NULL;
  SoDialogViz::finish();

  root->unref();
  delete myViewer;

  SoVectorizePSAction::exitClass();
  SoVectorizeCGMAction::exitClass();
  SoVectorizeAction::exitClass();
  SoXt::finish();

  return 0;
}
