/*=============================================================================
** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),       **
**              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                **
**                                                                           **
**  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS  **
**  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR  **
**  WRITTEN AUTHORIZATION OF FEI S.A.S.                                      **
**                                                                           **
**                        RESTRICTED RIGHTS LEGEND                           **
**  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS **
**  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN **
**  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT **
**  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN **
**  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.        **
**                                                                           **
**                   COPYRIGHT (C) 1996-2024 BY FEI S.A.S,                   **
**                             MERIGNAC, FRANCE                              **
**                           ALL RIGHTS RESERVED                             **
=============================================================================*/

#include <PhysicalMaterialWidget.h>
#include <Inventor/Qt/SbQtHelper.h>
#include <Inventor/SoInteraction.h>
#include <Inventor/ViewerComponents/Qt/RenderAreaOrbiter.h>
#include <Inventor/ViewerComponents/nodes/SoViewingCube.h>
#include <Inventor/nodes/SoFile.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoLightModel.h>
#include <Inventor/nodes/SoPhysicalMaterial.h>
#include <QApplication>
#include <QBoxLayout>
#include <QMainWindow>

int
main(int argc, char** argv)
{
  SbQtHelper::addPlatformPluginsPath();

  QApplication app(argc, argv);

  SoInteraction::init();

  // Scene graph
  SoRef<SoSeparator> root = new SoSeparator;

  SoLightModel* lightModel = new SoLightModel;
  lightModel->setOverride(TRUE);
  lightModel->model = SoLightModel::PHYSICALLY_BASED;
  root->addChild(lightModel);

  SoPhysicalMaterial* const material = new SoPhysicalMaterial;
  material->baseColor = SbColorRGBA(1.0f, 0.0f, 0.0f, 1.0f);
  material->specular = 1.0f;
  material->roughness = 0.5f;
  root->addChild(material);

  SoFile* const modelFile = new SoFile;
  modelFile->name = "$OIVHOME/examples/data/Inventor/Models/StanfordBunny.ivz";
  root->addChild(modelFile);


  // GUI
  QMainWindow* const mainWindow = new QMainWindow;

  QWidget* const centralWidget = new QWidget(mainWindow);
  centralWidget->setLayout(new QVBoxLayout);
  centralWidget->layout()->setContentsMargins(0, 0, 0, 0);
  centralWidget->layout()->setSpacing(0);

  PhysicalMaterialWidget* const highlightWidget = new PhysicalMaterialWidget(mainWindow, material);
  centralWidget->layout()->addWidget(highlightWidget);

  RenderAreaOrbiter* const renderArea = new RenderAreaOrbiter(mainWindow);
  renderArea->setTransparencyType(SoGLRenderAction::SORTED_PIXEL);
  renderArea->setClearColor(SbColorRGBA(1.0f, 1.0f, 1.0f, 1.0f));
  renderArea->setAntialiasingMode(SoSceneManager::SMAA);
  renderArea->setAntialiasingQuality(1.0f);
  centralWidget->layout()->addWidget(renderArea->getContainerWidget());
  mainWindow->setCentralWidget(centralWidget);

  // ViewingCube customization
  SoViewingCube* const vCube = renderArea->getSceneInteractor()->getViewingCube();
#define VCUBE_FACES_DIR "$OIVHOME/examples/data/Inventor/ViewingCube/Faces/xyz/"
  vCube->facePosX = VCUBE_FACES_DIR "xpos.png";
  vCube->faceNegX = VCUBE_FACES_DIR "xneg.png";
  vCube->facePosY = VCUBE_FACES_DIR "ypos.png";
  vCube->faceNegY = VCUBE_FACES_DIR "yneg.png";
  vCube->facePosZ = VCUBE_FACES_DIR "zpos.png";
  vCube->faceNegZ = VCUBE_FACES_DIR "zneg.png";
  vCube->edgeSize = 0.5f;
  vCube->edgeStyle = SoViewingCube::EdgeStyle::CORNER;

  renderArea->setSceneGraph(root.ptr());
  renderArea->viewAll(SbViewportRegion());
  mainWindow->resize(1600, 900);
  mainWindow->show();

  const int retVal = app.exec();

  // free the memory
  root = nullptr;
  delete mainWindow;
  SoInteraction::finish();

  return retVal;
}
