/*=============================================================================
** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),       **
**              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                **
**                                                                           **
**  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS  **
**  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR  **
**  WRITTEN AUTHORIZATION OF FEI S.A.S.                                      **
**                                                                           **
**                        RESTRICTED RIGHTS LEGEND                           **
**  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS **
**  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN **
**  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT **
**  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN **
**  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.        **
**                                                                           **
**                   COPYRIGHT (C) 1996-2024 BY FEI S.A.S,                   **
**                             MERIGNAC, FRANCE                              **
**                           ALL RIGHTS RESERVED                             **
=============================================================================*/


#include "PhysicalMaterialWidget.h"
#include <Inventor/nodes/SoPhysicalMaterial.h>
#include "ui_PhysicalMaterialWidget.h"

PhysicalMaterialWidget::PhysicalMaterialWidget(QWidget* parent, SoPhysicalMaterial* material)
: QWidget(parent)
, ui(new Ui::PhysicalMaterialWidget)
{
  // ui setting
  ui->setupUi(this);

  const std::tuple<QSlider*, QDoubleSpinBox*, SoSFFloat*> slidersTuples[] = {
    { ui->specularSlider, ui->specularSpinBox, &material->specular },
    { ui->roughnessSlider, ui->roughnessSpinBox, &material->roughness },
    { ui->metallicSlider, ui->metallicSpinBox, &material->metallic }
  };

  for (auto const& it : slidersTuples)
  {
    QSlider* slider = std::get<0>(it);
    QDoubleSpinBox* spinBox = std::get<1>(it);
    SoSFFloat* field = std::get<2>(it);

    slider->setRange(0, 100);
    spinBox->setRange(0.0, 1.0);
    spinBox->setSingleStep(0.05);

    connect(slider, &QSlider::valueChanged, spinBox, [=](int value) {
      spinBox->setValue(value / 100.0);
    });

    connect(spinBox, QOverload<double>::of(&QDoubleSpinBox::valueChanged), slider, [=](double value) {
      slider->setValue(value * 100);
      field->setValue(value);
    });
  }

  // Default setting
  ui->specularSpinBox->setValue(material->specular.getValue());
  ui->roughnessSpinBox->setValue(material->roughness.getValue());
  ui->metallicSpinBox->setValue(material->metallic.getValue());
}

PhysicalMaterialWidget::~PhysicalMaterialWidget()
{
  delete ui;
}
