//!oiv_include <Inventor/oivShaderState.h>
//!oiv_include <Inventor/oivShapeAttribute.h>

out vec3 vPos;
out vec4 vColor;
out vec3 vNormal;
uniform float basePointSize;
uniform bool sizeVarying;
uniform bool colorVarying;


void main()
{
  vec4 pos = OivModelViewProjectionMatrix() * OivVertexPosition();
  vPos = pos.xyz / pos.w;

  gl_Position = OivModelViewProjectionMatrix() * OivVertexPosition();

  vec2 vp = OivViewportSize();
  float heightOfNearPlane = vp[1] * 0.5 * OivProjectionMatrix()[1][1];
  float pointSize = (heightOfNearPlane * basePointSize) / gl_Position.w;

  if(sizeVarying)
    gl_PointSize = min(pointSize, 512.0);
  else  
    gl_PointSize = basePointSize;
    
  if(colorVarying)
    vColor = vec4(vec3(pointSize), 1.0);
  else
    vColor = vec4(1.0);
  vNormal = OivNormalMatrix() * OivVertexNormal();
}
