#include "DoubleSpinBoxSliderWidget.h"
#include <QDebug>
#include <QDoubleSpinBox>
#include <QSlider>
#include <QtMath>


DoubleSpinBoxSliderWidget::DoubleSpinBoxSliderWidget( QWidget* parent )
  : AbstractSpinBoxSliderWidget( parent )
{
  mSpinBox = new QDoubleSpinBox( this );
  buildWidget( mSpinBox );


  connect( mSlider, &QSlider::valueChanged, mSpinBox, [this]( int value ) { mSpinBox->setValue( value * mSpinBox->singleStep() ); } );

  connect( mSpinBox, QOverload<double>::of( &QDoubleSpinBox::valueChanged ), mSlider, [this]( double value ) {
    QSignalBlocker sb( mSlider );
    mSlider->setValue( qRound( value / mSpinBox->singleStep() ) );
  } );

  connect( mSpinBox, QOverload<double>::of( &QDoubleSpinBox::valueChanged ), this, &DoubleSpinBoxSliderWidget::valueChanged );
}

void
DoubleSpinBoxSliderWidget::setRange( double minimum, double maximum )
{
  mSpinBox->setRange( minimum, maximum );
  configureSlider();
}

void
DoubleSpinBoxSliderWidget::setSingleStep( double val )
{
  mSpinBox->setSingleStep( val );
  configureSlider();
}

void
DoubleSpinBoxSliderWidget::setValueMuted( double value )
{
  QSignalBlocker sb( this );
  setValue( value );
}

void
DoubleSpinBoxSliderWidget::setValue( double value )
{
  mSpinBox->setValue( value );
}

void
DoubleSpinBoxSliderWidget::configureSlider()
{
  mSlider->setRange( mSpinBox->minimum(), qCeil( static_cast<double>( mSpinBox->maximum() ) / mSpinBox->singleStep() ) );
}
