#pragma once
#include <AbstractSpinBoxSliderWidget.h>

class QDoubleSpinBox;

class DoubleSpinBoxSliderWidget : public AbstractSpinBoxSliderWidget
{
  Q_OBJECT
public:
  DoubleSpinBoxSliderWidget( QWidget* parent = nullptr );
  void setRange( double minimum, double maximum );
  void setSingleStep( double val );
  void setValueMuted( double value );

public slots:
  void setValue( double value );

signals:
  void valueChanged( double value );

private:
  void configureSlider();
  QDoubleSpinBox* mSpinBox;
};
