#pragma once
#include <Inventor/SbVec.h>

#include <Inventor/misc/SoRef.h>

class SoSeparator;
class SoText2;
class SoDrawStyle;
class SoShaderParameter1i;

class Scene
{
public:
  Scene();

  SoSeparator* getRoot() const;
  SoDrawStyle* getDrawStyle() const;
  SoShaderParameter1i* getSpSizeVarying() const;
  SoShaderParameter1i* getSpColorVarying() const;
  void clear();

  void setText(const SbString& text);

private:
  SbVec3f computeNormal(const SbVec3f &p0, const SbVec3f &p1, const SbVec3f &p2 );
  SbVec3f getPoint( int i, int j );

  const int NUM_POINTS_PER_AXIS = 1000;
  const float POINT_SPACE = 10.f;

  SbVec3f m_origin;

  SoDrawStyle* m_drawStyle = nullptr;
  SoShaderParameter1i* m_spSizeVarying = nullptr;
  SoShaderParameter1i* m_spColorVarying = nullptr;
  SoRef<SoSeparator> m_root = nullptr;
  SoRef<SoText2> m_text;
};
