/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2025 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/

#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>

#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoFaceSet.h>
#include <Inventor/nodes/SoDepthBuffer.h>
#include <Inventor/nodes/SoCube.h>
#include <Inventor/nodes/SoLineSet.h>
#include <Inventor/nodes/SoMaterial.h>
#include <Inventor/nodes/SoCoordinate3.h>
#include <Inventor/nodes/SoShapeHints.h>
#include <Inventor/nodes/SoMaterialBinding.h>

int
main(int, char **argv)
{
  static SbVec3f vertices[5] = { SbVec3f(1, 1, 0), SbVec3f(1, -1, 0), SbVec3f(-1, -1, 0), SbVec3f(-1, 1, 0), SbVec3f(1, 1, 0) };

  // Initialize Inventor and Xt
  Widget myWindow = SoXt::init(argv[0]);

  SoRef<SoSeparator> root = new SoSeparator();

  SoCoordinate3* coords = new SoCoordinate3();
  coords->point.setValues(0, 5, (const class SbVec3f*)vertices);

  SoShapeHints* shapeHint = new SoShapeHints();
  shapeHint->vertexOrdering.setValue(SoShapeHints::CLOCKWISE);

  SoSeparator* faceSep = new SoSeparator();
  {
    // Blue color material in front.
    SoMaterialBinding* materialBindingFrontFlag = new SoMaterialBinding();
    materialBindingFrontFlag->face = SoMaterialBinding::FRONT;
    SoMaterial* materialFrontFlag = new SoMaterial();
    materialFrontFlag->diffuseColor.setValue(0.f, 0.f, 1.f);

    // Green color material in back.
    SoMaterialBinding* materialBindingBackFlag = new SoMaterialBinding();
    materialBindingBackFlag->face = SoMaterialBinding::BACK;
    SoMaterial* materialBackFlag = new SoMaterial();
    materialBackFlag->diffuseColor.setValue(0.f, 1.f, 0.f);

    SoDepthBuffer* faceDepth = new SoDepthBuffer();
    faceDepth->range.setValue(0.f, 1.f);

    SoFaceSet* face = new SoFaceSet();
    face->numVertices.setValue(4);

    faceSep->addChild(materialBindingFrontFlag);
    faceSep->addChild(materialFrontFlag);
    faceSep->addChild(materialBindingBackFlag);
    faceSep->addChild(materialBackFlag);
    faceSep->addChild(faceDepth);
    faceSep->addChild(face);
  }

  SoSeparator* lineSep = new SoSeparator();
  {
    SoMaterial* lineMaterial = new SoMaterial();
    lineMaterial->diffuseColor.setValue(1.f, 0.f, 0.f);

    SoDepthBuffer* lineDepth = new SoDepthBuffer();
    lineDepth->function.setValue(SoDepthBuffer::ALWAYS);

    SoLineSet* line = new SoLineSet();
    line->numVertices.setValue(5);

    lineSep->addChild(lineMaterial);
    lineSep->addChild(lineDepth);
    lineSep->addChild(line);
  }

  root->addChild(coords);
  root->addChild(shapeHint);
  root->addChild(lineSep);
  root->addChild(faceSep);

  // Create a viewer
  SoXtExaminerViewer* myViewer = new SoXtExaminerViewer(myWindow);

  // attach and show viewer
  myViewer->setSceneGraph(root.ptr());
  myViewer->setTitle("Depth Buffer");
  myViewer->show();

  // Loop forever
  SoXt::show(myWindow);
  SoXt::mainLoop();

  root = nullptr;
  delete myViewer;
  SoXt::finish();

  return 0;
}
