/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2020 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : Nicolas DAGUISE (Dec 2008)
**=======================================================================*/


#include <Inventor/SoDB.h>
#include <Inventor/SoInput.h>
#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/nodes/SoSeparator.h>

int
main(int, char **argv)
{
  Widget myWindow = SoXt::init(argv[0]);

  SbString ivFile = "$OIVHOME/examples/source/Inventor/Features/PolygonOffset/depthOffset.iv";

  SoInput mySceneInput;
  if (!mySceneInput.openFile(ivFile))
  {
    fprintf(stderr, "Cannot open file %s\n", ivFile.toLatin1());
    return 0;
  }
  
  SoSeparator *scene = SoDB::readAll(&mySceneInput);
  if (scene == NULL)
  {
    fprintf(stderr, "Problem reading file\n");
    return 0;
  } 
  mySceneInput.closeFile();

  SoXtExaminerViewer *myViewer = new SoXtExaminerViewer(myWindow);
  
  myViewer->setSceneGraph(scene);
  myViewer->setTitle("");
  myViewer->show();
  SoXt::show(myWindow);
  SoXt::mainLoop();
  delete myViewer;

  SoXt::finish();
  return 0;
}



