#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>

#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoPolygonOffset.h>
#include <Inventor/nodes/SoCube.h>
#include <Inventor/nodes/SoLineSet.h>
#include <Inventor/nodes/SoMaterial.h>
#include <Inventor/nodes/SoCoordinate3.h>

int
main(int, char **argv)
{
  static SbVec3f vertices[12] = {
    SbVec3f(1, 1, 1), SbVec3f(-1, -1, 1), SbVec3f(1, 1, 1), SbVec3f(-1, 1, -1), 
    SbVec3f(1, 1, 1), SbVec3f(1, -1, -1), SbVec3f(-1, -1, -1), SbVec3f(1, 1, -1), 
    SbVec3f(-1, -1, -1), SbVec3f(1, -1, 1), SbVec3f(-1, -1, -1), SbVec3f(-1, 1, 1)
  };

  // Initialize Inventor and Xt
  Widget myWindow = SoXt::init(argv[0]);

  SoSeparator *root = new SoSeparator;
  SoSeparator *sep = new SoSeparator;
  SoCube *cube = new SoCube;

  SoCoordinate3 *coords = new SoCoordinate3;
  coords->point.setValues(0, 12, (const class SbVec3f *)vertices); 

  SoLineSet *lineSet = new SoLineSet;
  lineSet->numVertices.set1Value(0, 12);

  SoPolygonOffset *polygonOffset =  new SoPolygonOffset;
  polygonOffset->factor = 1.;
  polygonOffset->units = 1.;

  SoMaterial *mat = new SoMaterial;
  mat->diffuseColor.setValue(1, 0, 0);

  SoSeparator *cubeSep = new SoSeparator;
  cubeSep->addChild(cube);
  cubeSep->addChild(mat);
  cubeSep->addChild(coords);
  cubeSep->addChild(lineSet);

  root->ref();
  root->addChild(sep);

  sep->addChild(polygonOffset);
  sep->addChild(cubeSep);   
  
  // Create a viewer
  SoXtExaminerViewer *myViewer = new SoXtExaminerViewer(myWindow);

  // attach and show viewer
  myViewer->setSceneGraph(root);
  myViewer->setTitle("Polygon Offset");
  myViewer->show();
    
  // Loop forever
  SoXt::show(myWindow);
  SoXt::mainLoop();

  root->unref();
  delete myViewer;
  SoXt::finish();

  return 0;
}

