
/*
In this example, we want to display a sphere with a custom defined projection.
An instance of a class MyCustomProjection is created.
This class redefine the internalProject() method of the SbProjection basic class.

We add a SoProjection node and set the projection routine to the MyCustomProjection instance.
*/

#include <Inventor/SoInput.h>

#include <Inventor/nodes/SoSeparator.h>

#include <Inventor/nodes/SoSphere.h>
#include <Inventor/nodes/SoProjection.h>
#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>

#include <Inventor/projection/SbProjection.h>

//Our projection routine class
class MyCustomProjection : public SbProjection
{

public:
  // As this projection is linear, projecting a bounding box
  // is equivalent to the bbox of the projected points.
  // Then defining this method allow to speed up some rendering nodes.
  virtual bool getProjectedBoundingBox( SbBox3f& bbox )
  {
    SbVec3f boundary[2];
    bbox.getBounds(boundary[0],boundary[1]);
    project(boundary[0]);
    project(boundary[1]);
    bbox.setBounds(boundary[0],boundary[1]);
    return true;
  }

protected:

  // apply the projection to one point.
  virtual void apply( SbVec3f &point )
  {
    point[2] *= 3.;
  }

};


int main( int , char **argv )
{

  Widget myWindow = SoXt::init( argv[0] );  
  if ( myWindow == NULL ) 
    exit(1);     

  //Create viewer 
  SoXtExaminerViewer *viewer = new SoXtExaminerViewer( myWindow );
  viewer->setTitle("Examiner Viewer");

  //Create main separator
  SoSeparator* root = new SoSeparator;
  root->ref();
  
  //Create projection node
  SoProjection* projectionNode = new SoProjection;
  root->addChild( projectionNode );

  MyCustomProjection* customProjection = new MyCustomProjection;
  projectionNode->setProjection( customProjection );

  //Create sphere to display
  SoSphere* sphere = new SoSphere;
  root->addChild( sphere );

  //Set scene graph to viewer
  viewer->setSceneGraph( root );

  viewer->show();

  SoXt::show( myWindow );

  SoXt::mainLoop();
  SoXt::finish();

  return 0;

}

