
/*
In this example, we want to display a sphere representing the earth with a cartographic projection.
We add a SoGeoProjection node with coordinateSystem set as geocentric.
The displayed shape is a sphere with the radius the earth radius (6371000 meters)
*/

#include <Inventor/SoInput.h>

#include <Inventor/nodes/SoSeparator.h>

#include <Inventor/nodes/SoGeoProjection.h>
#include <Inventor/nodes/SoSphere.h>
#include <Inventor/nodes/SoTexture2.h>
#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>


int main( int , char **argv )
{
 
  Widget myWindow = SoXt::init( argv[0] );  
  if ( myWindow == NULL ) 
    exit(1);     

  //Create viewer 
  SoXtExaminerViewer *viewer = new SoXtExaminerViewer( myWindow );
  viewer->setTitle("Examiner Viewer");

  //Create main separator
  SoSeparator* root = new SoSeparator;
  root->ref();

  //Create a SoGeoProjection node
  SoGeoProjection* geoProjection = new SoGeoProjection;
  root->addChild( geoProjection );

  //Set the coordinate system to GEOCENTRIC
  geoProjection->coordinateSystem.setValue( SbProj4Projection::GEOCENTRIC );

  //Choose the mollweide projection
  geoProjection->projection.setValue( SbProj4Projection::MOLLWEIDE );

  //Add the earth texture
  SoTexture2* texture = new SoTexture2;
  texture->filename.setValue( "$OIVHOME/examples/source/Inventor/Features/Projection/GeocentricProjection/earth.jpg" );
  texture->model.setValue( SoTexture2::REPLACE);
  root->addChild( texture );

  // Add the shape that is being projected. We use a sphere to approximate the earth
  // We set the radius to 6371000 m (6371 km)
  SoSphere* sphere = new SoSphere;
  sphere->radius.setValue( 6371000 );
  root->addChild( sphere );

  viewer->setSceneGraph( root );

  viewer->show();

  SoXt::show( myWindow );

  SoXt::mainLoop();

  SoXt::finish();

  return 0;

}

