

/*
In this example, we want to display an SoQuadMesh node representing the earth with a cartographic projection.
We add a SoGeoProjection node and choose the Mollweide projection.

The displayed shape is an SoQuadMesh node defined in the geodetic interval [-180,90] to [180,90].
*/

#include <Inventor/SoInput.h>

#include <Inventor/nodes/SoSeparator.h>

#include <Inventor/nodes/SoGeoProjection.h>
#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>

int main( int , char **argv )
{

  Widget myWindow = SoXt::init( argv[0] );
  if( myWindow == NULL )
    exit(1);

  //Create viewer
  SoXtExaminerViewer *viewer = new SoXtExaminerViewer( myWindow );
  viewer->setTitle("Examiner Viewer");

  //Open earth geodetic model : SoQuadMesh node with vertices defined in the intervals [-180,-90] to [180,90]
  SoInput input;
  if ( !input.openFile( "$OIVHOME/examples/source/Inventor/Features/Projection/GeodeticProjection/earth.iv" ) )
    return 0;

  SoSeparator* sep = SoDB::readAll( &input );
  input.closeFile();
  sep->ref();

  //Create and insert SoGeoProjection node
  SoGeoProjection* geoProjection = new SoGeoProjection;
  geoProjection->projection.setValue( SbProj4Projection::MOLLWEIDE );
  sep->insertChild( geoProjection, 0 );

  //Set scene graph
  viewer->setSceneGraph( sep );

  viewer->show();

  SoXt::show( myWindow );

  SoXt::mainLoop();

  SoXt::finish();

  return 0;

}

