#include <Inventor/devices/SoCpuBufferObject.h>
#include <Inventor/image/SoRasterImageFile.h>
#include "PPMImageRW.h"

SO_IMAGE_RASTER_RW_SOURCE( SoRasterImageRW, PPMImageRW, "PPMImageRW" );

PPMImageRW::PPMImageRW()
{
  createSuffixList();
}

SbBool
PPMImageRW::write( SbRasterImage* rasterImage, unsigned int /*xPos*/, unsigned int /*yPos*/ )
{

  FILE* m_fp = NULL;
  if ( m_rasterImageIO != NULL )
  {
    if ( m_rasterImageIO->getTypeId() == SoRasterImageFile::getClassTypeId() )
    {
      SoRasterImageFile* myRasterImageFile = ( SoRasterImageFile* )m_rasterImageIO;
      m_fp = myRasterImageFile->getFilePointer();

      SbVec2s size = rasterImage->getSize();
      SoBufferObject* bufferObject = rasterImage->getBufferObject();
      SoRef< SoCpuBufferObject > cpuBuffer = new SoCpuBufferObject();
      bufferObject->map( cpuBuffer.ptr(), SoBufferObject::READ_WRITE );
      unsigned char* buffer = ( unsigned char* )cpuBuffer->map( SoBufferObject::READ_WRITE );

      for ( int j = size[1] - 1; j >= 0; j-- )
      {
        for ( int i = 0; i < size[0] * 3; i++ )
        {
          fprintf( m_fp, "%d ", buffer[i + j * size[0] * 3] );
        }
        fprintf( m_fp, "\n" );
      }

      cpuBuffer->unmap();
      bufferObject->unmap( cpuBuffer.ptr() );

      return TRUE;
    }
  }

  return FALSE;
}

SbBool
PPMImageRW::read( SbRasterImage* rasterImage, SbBool infoOnly )
{
  FILE* fp;

  if ( m_rasterImageIO->getTypeId() != SoRasterImageFile::getClassTypeId() )
  {
    return FALSE;
  }

  SoRasterImageFile* myRasterImageFile = ( SoRasterImageFile* )m_rasterImageIO;
  fp = myRasterImageFile->getFilePointer();

  // Check type
  char type[3];
  fscanf( fp, "%s\n", type );
  if ( strcmp( type, "P3" ) )
    return FALSE;

  char comment[512];
  fgets( comment, 512, fp );

  int width, height;
  fscanf( fp, "%d %d\n", &width, &height );

  SbVec2s tmp( width, height );
  rasterImage->setSize( tmp );
  rasterImage->setComponents( SbRasterImage::RGB );

  if ( infoOnly )
    return TRUE;

  int range;
  fscanf( fp, "%d\n", &range );

  unsigned char* buffer = new unsigned char[width * height * 3];

  int i, j;
  for ( i = 0; i < width * height * 3; i++ )
  {
    fscanf( fp, "%d", &j );
    buffer[i] = ( unsigned char )j;
  }

  // reverse buffer
  SoRef< SoCpuBufferObject > imageBufferObject = new SoCpuBufferObject();
  imageBufferObject->setSize( width * height * 3 * sizeof( unsigned char ) );
  unsigned char* revBuffer = ( unsigned char* )imageBufferObject->map( SoBufferObject::READ_WRITE );

  for ( j = 0; j < height; j++ )
  {
    for ( i = 0; i < width * 3; i++ )
    {
      revBuffer[i + ( height - 1 - j ) * ( width * 3 )] = buffer[i + j * width * 3];
    }
  }

  delete[] buffer;

  imageBufferObject->unmap();
  rasterImage->setBuffer( imageBufferObject.ptr() );

  return TRUE;
}

SbBool
PPMImageRW::writeHeader( const SbVec2i32& size )
{
  if ( m_rasterImageIO->getTypeId() != SoRasterImageFile::getClassTypeId() )
  {
    return FALSE;
  }

  SoRasterImageFile* myRasterImageFile = ( SoRasterImageFile* )m_rasterImageIO;
  m_fp = myRasterImageFile->getFilePointer();

  fprintf( m_fp, "P3\n" );
  fprintf( m_fp, "# Created by Open Inventor\n" );
  fprintf( m_fp, "%d %d\n", size[0], size[1] );
  fprintf( m_fp, "255\n" );

  return TRUE;
}

SbString
PPMImageRW::getSuffix() const
{
  return SbString( "PPM" );
}

void
PPMImageRW::createSuffixList()
{
  m_numSuffixes = 1;
  m_suffixes = new SbString[m_numSuffixes];
  m_suffixes[0] = "PPM";
}
