/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2020 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
/*=======================================================================
** Author      : C. OGNIER (Jun 2003)
**=======================================================================*/

#include <Inventor/SbViewportRegion.h>
#include <Inventor/SoDB.h>
#include <Inventor/SoOffscreenRenderArea.h>
#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/events/SoKeyboardEvent.h>
#include <Inventor/image/SoRasterImageFile.h>
#include <Inventor/image/SoRasterReaderSet.h>
#include <Inventor/nodes/SoCube.h>
#include <Inventor/nodes/SoEventCallback.h>
#include <Inventor/nodes/SoPerspectiveCamera.h>
#include <Inventor/nodes/SoPointLight.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoTexture2.h>

#include <Inventor/helpers/SbFileHelper.h>

#include "PPMImageRW.h"

typedef unsigned char ui8;

void
processKeyEvents( void* userData, SoEventCallback* cb )
{
  SoXtExaminerViewer* viewer = ( SoXtExaminerViewer* )userData;

  if ( SO_KEY_PRESS_EVENT( cb->getEvent(), P ) )
  {

    SoRef< SoOffscreenRenderArea > myOffscreen = new SoOffscreenRenderArea( viewer->getNormalSoContext() );
    myOffscreen->setSceneGraph( viewer->getSceneGraph() );
    SbViewportRegion sb = viewer->getViewportRegion();
    myOffscreen->setViewportRegion( sb );
    SoRef< SoCpuBufferObject > buffer = new SoCpuBufferObject();
    myOffscreen->renderToBuffer( buffer.ptr() );

    SbVec2i32 imgSize = viewer->getViewportRegion().getViewportSizePixels_i32();
    SbRasterImage* raster = new SbRasterImage;
    raster->setSize_i32( imgSize );
    raster->setComponents( SbRasterImage::RGB );
    raster->setBuffer( buffer.ptr() );

    PPMImageRW* imageWriter = new PPMImageRW();
    SoRasterImageIO* imageIO = new SoRasterImageFile( "output.ppm" );

    if ( imageWriter->open( imageIO, SoRasterImageRW::OPEN_WRITE ) )
    {
      imageWriter->writeHeader( imgSize );
      imageWriter->write( raster );
      imageWriter->close();
    }

    delete imageWriter;
    delete imageIO;
    delete raster;

    printf( "File done\n" );
  }
}

int
main( int, char** argv )
{
  // Initialize Inventor and Xt
  Widget appWindow = SoXt::init( argv[0] );
  if ( appWindow == NULL )
    exit( 1 );

  SoSeparator* root = new SoSeparator;
  root->ref();

  SoEventCallback* eventCB = new SoEventCallback;
  root->addChild( eventCB );

  SoPerspectiveCamera* camera = new SoPerspectiveCamera;
  root->addChild( camera );

  SoPointLight* light = new SoPointLight;
  light->location.setValue( 0, 0, 5 );
  root->addChild( light );

  PPMImageRW* myPPMImageRW = new PPMImageRW();

  SoRasterReaderSet::addReader( myPPMImageRW );

  SoTexture2* texture = new SoTexture2();
  SbString texturefile =
    SbFileHelper::expandString( "$OIVHOME/examples/source/Inventor/Features/RasterRW/input.ppm" );
  texture->filename.setValue( texturefile );
  root->addChild( texture );
  root->addChild( new SoCube );

  // Initialize the viewer
  SoXtExaminerViewer* viewer = new SoXtExaminerViewer( appWindow );
  viewer->setSceneGraph( root );
  viewer->setTitle( "rasterRW" );
  // viewer->setSize(SbVec2s(300, 300));

  // In Inventor 2.1, if the machine does not have hardware texture
  // mapping, we must override the default drawStyle to display textures.
  viewer->setDrawStyle( SoXtViewer::STILL, SoXtViewer::VIEW_AS_IS );

  eventCB->addEventCallback( SoKeyboardEvent::getClassTypeId(), processKeyEvents, ( void* )viewer );

  printf( "Press P in picking mode to write output file\n" );

  viewer->show();
  camera->viewAll( root, viewer->getViewportRegion() );

  SoXt::show( appWindow );
  SoXt::mainLoop();

  root->unref();
  delete viewer;
  SoXt::finish();

  return 0;
}
