/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2020 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : C. OGNIER (Dec 2004)
**=======================================================================*/

#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/actions/SoGetBoundingBoxAction.h>
#include <Inventor/actions/SoGetPrimitiveCountAction.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoSwitch.h>
#include <Inventor/nodes/SoTransformSeparator.h>
#include <Inventor/nodes/SoTranslation.h>
#include <Inventor/nodes/SoMaterial.h>
#include <Inventor/nodes/SoScale.h>
#include <Inventor/nodes/SoTexture2.h>
#include <Inventor/nodes/SoShapeHints.h>
#include <Inventor/nodes/SoEnvironment.h>
#include <Inventor/nodes/SoSwitch.h>
#include <Inventor/nodes/SoDirectionalLight.h>
#include <Inventor/nodes/SoCamera.h>
#include <Inventor/nodes/SoCube.h>
#include <Inventor/nodes/SoCone.h>
#include <Inventor/nodes/SoSphere.h>
#include <Inventor/nodes/SoTexture2.h>
#include <Inventor/nodes/SoTextureCubeMap.h> 
#include <Inventor/nodes/SoTextureCoordinateReflectionMap.h> 
#include <Inventor/nodes/SoTextureCoordinateObject.h> 
#include <Inventor/nodes/SoRenderToTextureProperty.h>
#include <Inventor/sensors/SoFieldSensor.h>
#include <Inventor/SoInput.h>
#include <Inventor/nodes/SoPointLight.h> 
#include <Inventor/nodes/SoComplexity.h> 
#include <Inventor/actions/SoWriteAction.h> 
#include <Inventor/nodes/SoQuadMesh.h>
#include <Inventor/nodes/SoBaseColor.h>
#include <Inventor/nodes/SoDrawStyle.h>
#include <Inventor/nodes/SoPerspectiveCamera.h>
#include <Inventor/nodes/SoLightModel.h>
#include <Inventor/sensors/SoIdleSensor.h>
#include <Inventor/nodes/SoRotation.h> 
#include <Inventor/nodes/SoShapeHints.h> 
#include <DialogViz/SoDialogVizAll.h>

#include <Inventor/helpers/SbFileHelper.h>


SoXtExaminerViewer*    mainViewer         = NULL;
SoXtExaminerViewer*    renderToTexViewer  = NULL;
SoSeparator*           mainRoot           = NULL;
SoSeparator*           mainSep            = NULL;
SoSwitch*              renderToTexRoot    = NULL;


SoTopLevelDialog* topLevelDialog0 = NULL;
SoDialogCustom*   customNode0     = NULL;
SoDialogCustom*   customNode1     = NULL;
SoColumnDialog*   customNode2     = NULL;


int selectedShape = 0;

SoRenderToTextureProperty* renderToTexProperty  = NULL;
SoRenderToTextureProperty* renderToTexProperty2 = NULL;
SoTexture2* tex2D = NULL;
SoTextureCubeMap* texCubemap = NULL;

SoIdleSensor* iSensor = NULL;

SoGetPrimitiveCountAction* countAction;
Widget buildInterface(Widget);
void   fpsCallback(float fps, void* userData, SoXtViewer* viewer);





//////////////////////
// Animated surface //
//////////////////////

#define N 20
SoVertexProperty *myVertexProperty;
typedef float pointarray[N][N][3];
pointarray points1, points2;
unsigned int colors[N][N];


SoQuadMesh * myQuadMesh ;

void initPoints() {
  for (int i = 0; i < N; i++)  
    for (int j = 0; j < N; j++) {
      points1[i][j][0] = (float)i;
      points1[i][j][1] = (float)j;
      points1[i][j][2] = 0;
      points2[i][j][2] = 0;
      colors[i][j] = SbColor(0, 0, 1).getPackedValue();
    }
}

void nextPoints(SbVec3f* dest, unsigned int* colors)
{
  int d = 0;
  static int t = 0;

  t++;
  points1[0][0][2] = sin((float)t / 3.0f) * 2;

  int i, j;

  for (i = N - 1; i >= 0; i--) {
    for (j = N - 1; j >= 0; j--) {
      int divider = 1;
      if (i > 0) points1[i][j][2] += points1[i - 1][j][2], divider++;
      if (j > 0) points1[i][j][2] += points1[i][j - 1][2], divider++;
      points1[i][j][2] /= divider;
    }
  }

  points2[0][N - 1][2] = sin(t / 3.0f) * 2;
  for (i = N - 1; i >= 0; i--) {
    for (j = 0; j < N; j++) {     
      int divider = 1;
      if (i > 0) points2[i][j][2] += points2[i - 1][j][2], divider++;
      if (j < N - 1) points2[i][j][2] += points2[i][j + 1][2], divider++;
      points2[i][j][2] /= divider;
    }
  }

  for (j = 0; j < N; j++) {
    for (i = 0; i < N; i++) {
      float height = points1[i][j][2] + points2[i][j][2] / 2;
      colors[d] = SbColor(height / 4 + 0.6f, height / 4 + 0.6f, 1).getPackedValue();
      dest[d++][2] = height;
    }
  }
}


SoSeparator*
makeArch()
{
  initPoints();

  SoSeparator *result = new SoSeparator;
  result->ref();

  SoRotation* rot = new SoRotation;
  rot->rotation.setValue(1, 1, 0, 0);

  myVertexProperty = new SoVertexProperty;

  // Define the material
  myVertexProperty->materialBinding.setValue(SoVertexProperty::PER_VERTEX);
  myVertexProperty->orderedRGBA.setValues(0, N * N, &colors[0][0]);

  // Define coordinates for vertices
  myVertexProperty->vertex.setValues(0, N * N, &points1[0][0]);

  // Define the QuadMesh.
  myQuadMesh = new SoQuadMesh;
  myQuadMesh->verticesPerRow = N;
  myQuadMesh->verticesPerColumn = N;
  myQuadMesh->vertexProperty.setValue(myVertexProperty);

  SoShapeHints* sh = new SoShapeHints;
  sh->vertexOrdering.setValue(SoShapeHints::CLOCKWISE);

  result->addChild(rot);
  result->addChild(sh);
  result->addChild(myQuadMesh);

  result->unrefNoDelete();
  return result;
}

void cb(void*, SoSensor* s)
{
  nextPoints(myVertexProperty->vertex.startEditing(), myVertexProperty->orderedRGBA.startEditing());
  myVertexProperty->vertex.finishEditing();
  myVertexProperty->orderedRGBA.finishEditing();

  s->schedule();
}

//Function called when main window is closed
void exitCB (void *, SoXtComponent *)
{
  mainViewer->setFramesPerSecondCallback(NULL, NULL);
  iSensor->unschedule();
}

//////////
// MAIN //
//////////

int
main(int argc, char **argv)
{
  // Initialize Inventor. This returns a main window to use.
  // If unsuccessful, exit.
  Widget mainWindow = SoXt::init(argv[0]); // pass the app name
  SoDialogViz::init();

  bool fullDemo = !(argc >= 2 && argv[1] && strcmp(argv[1], "-noanim") == 0);

  if (mainWindow == NULL) exit(1);

  // Set up viewer
  Widget parent = buildInterface(mainWindow);

  mainViewer = new SoXtExaminerViewer(parent);

  mainRoot = new SoSeparator;
  mainRoot->ref();


  // Frame per second          
  countAction = new SoGetPrimitiveCountAction();
  mainViewer->setNumSamples(1);
  if (fullDemo) mainViewer->setFramesPerSecondCallback(fpsCallback, mainViewer);
  mainViewer->setWindowCloseCallback(exitCB, NULL);

  // Default iv file.
  SoInput myInput;
  myInput.openFile( "$OIVHOME/data/models/wheel.iv" );
  mainSep = SoDB::readAll(&myInput);
  mainRoot->addChild(mainSep);


  mainViewer->setSceneGraph(mainRoot);
  mainViewer->setBackgroundColor(SbColor(0.8f, 0.0f, 1.f));
  mainViewer->setTransparencyType(SoGLRenderAction::OPAQUE_FIRST);
  mainViewer->show();        
  SoXt::show(mainWindow);  // Display main window   
  mainViewer->viewAll();


  // Create the renderToTex viewer
  renderToTexViewer = new SoXtExaminerViewer(customNode1->getWidget());
  renderToTexRoot = new SoSwitch;
  renderToTexRoot->ref();
  renderToTexRoot->whichChild.setValue(0);

  // texture 2D separator
  SoSeparator* texture2DSep = new SoSeparator;

  tex2D = new SoTexture2;
  renderToTexProperty = new SoRenderToTextureProperty;
  renderToTexProperty->ref();

  tex2D->renderToTextureProperty.setValue(renderToTexProperty);
  tex2D->filename.setValue(SbFileHelper::expandString("$OIVHOME/examples/source/Inventor/Features/RenderToTexture/two.jpg"));


  tex2D->model.setValue(SoTexture::MODULATE);  
  renderToTexProperty->component = SoRenderToTextureProperty::RGB;  
  renderToTexProperty->size.setValue(SbVec2s(512, 512));
  renderToTexProperty->updatePolicy = SoRenderToTextureProperty::WHEN_NEEDED;
  renderToTexProperty->backgroundColor.setValue(mainViewer->getBackgroundColor());
  renderToTexProperty->node.set1Value(0, (SoNode*) mainViewer->getSceneManager()->getSceneGraph()); 
  SoComplexity* complexity = new SoComplexity;
  complexity->value.setValue(1.);
  complexity->textureQuality.setValue(1.);
  texture2DSep->addChild(complexity);
  texture2DSep->addChild(tex2D);  
  texture2DSep->addChild(makeArch());

  // Texture Cubemap separator
  
  SoSeparator* textureCubemapSep = new SoSeparator;
  texCubemap = new SoTextureCubeMap;

  texCubemap->model.setValue(SoTexture::REPLACE);

  renderToTexProperty2 = new SoRenderToTextureProperty;
  renderToTexProperty2->ref();
  texCubemap->renderToTextureProperty.setValue(renderToTexProperty2);

  renderToTexProperty2->component = SoRenderToTextureProperty::RGB_TRANSPARENCY;  
  renderToTexProperty2->size.setValue(SbVec2s(512, 512));  

  renderToTexProperty2->backgroundColor.setValue(SbColor(0.98f, 0.82f, 0.32f));

  SoNode* cubeFaceNode = (SoNode*) mainViewer->getSceneManager()->getSceneGraph();

  renderToTexProperty2->node.set1Value(0, cubeFaceNode);
  renderToTexProperty2->node.set1Value(1, cubeFaceNode);
  renderToTexProperty2->node.set1Value(2, cubeFaceNode);
  renderToTexProperty2->node.set1Value(3, cubeFaceNode);
  renderToTexProperty2->node.set1Value(4, cubeFaceNode);
  renderToTexProperty2->node.set1Value(5, cubeFaceNode);

  renderToTexProperty2->updatePolicy = SoRenderToTextureProperty::WHEN_NEEDED;  

  textureCubemapSep->addChild(complexity);
  textureCubemapSep->addChild(new SoTextureCoordinateObject);
  textureCubemapSep->addChild(texCubemap);
  textureCubemapSep->addChild(new SoSphere);

  renderToTexRoot->addChild(texture2DSep);  
  renderToTexRoot->addChild(textureCubemapSep);  
  renderToTexViewer->setSceneGraph(renderToTexRoot);
  renderToTexViewer->setBackgroundColor(SbColor(0.f, 0.f, 0.15f));
  renderToTexViewer->setTransparencyType(SoGLRenderAction::OPAQUE_FIRST);
  renderToTexViewer->show();        
  renderToTexViewer->viewAll(); 


  iSensor = new SoIdleSensor(cb, 0);
  iSensor->schedule();

  if (!fullDemo) {
    SoDialogCheckBox* cpt3 = (SoDialogCheckBox*)topLevelDialog0->searchForAuditorId(SbString("animation"));
    cpt3->state.setValue(FALSE);
    iSensor->unschedule();
  }

  SoXt::mainLoop();      // Main Inventor event loop
    
  renderToTexProperty->unref();
  renderToTexProperty2->unref();
  mainRoot->unref();
  renderToTexRoot->unref();
  delete mainViewer;
  delete renderToTexViewer;
  delete iSensor;
  SoDialogViz::finish();
  SoXt::finish();

  return (0);
}


class auditorClass : public SoDialogAuditor
{
public:
  void menuFileSelection(SoMenuFileSelection* cpt);
  void dialogCheckBox(SoDialogCheckBox* cpt);
  void dialogPushButton(SoDialogPushButton* cpt);  
  void dialogComboBox(SoDialogComboBox* cpt);  
  void dialogIntegerSlider(SoDialogIntegerSlider* cpt);
  void dialogRealSlider(SoDialogRealSlider* cpt);
};


void 
auditorClass::dialogIntegerSlider(SoDialogIntegerSlider* cpt)
{
  if (cpt->auditorID.getValue() == "size") {
    SoDialogComboBox*   cpt0 = (SoDialogComboBox*)   topLevelDialog0->searchForAuditorId(SbString("shape"));
    if (cpt0->selectedItem.getValue() == 0)
      renderToTexProperty->size.setValue(cpt->value.getValue(), cpt->value.getValue());
    else
      renderToTexProperty2->size.setValue(cpt->value.getValue(), cpt->value.getValue());
  }
}


void 
auditorClass::dialogRealSlider(SoDialogRealSlider* cpt)
{
  if (cpt->auditorID.getValue() == "exposure") {
    texCubemap->HDRIExposure.setValue(cpt->value.getValue());    
  }
}


void 
auditorClass::dialogCheckBox(SoDialogCheckBox* cpt)
{
  SoDialogCheckBox*   cpt1 = (SoDialogCheckBox*)   topLevelDialog0->searchForAuditorId(SbString("display"));
  SoDialogComboBox*   cpt2 = (SoDialogComboBox*)   topLevelDialog0->searchForAuditorId(SbString("shape"));
  SoDialogCheckBox*   cpt3 = (SoDialogCheckBox*)   topLevelDialog0->searchForAuditorId(SbString("animation"));

  if (cpt1->state.getValue() == TRUE) {
    if (cpt2->selectedItem.getValue() == 0) {
      renderToTexRoot->whichChild.setValue(0);
      cpt3->enable.setValue(TRUE);      
    }
    else {
      renderToTexRoot->whichChild.setValue(1);
      cpt3->state.setValue(FALSE);
      iSensor->unschedule();
      cpt3->enable.setValue(FALSE);      
    }
    renderToTexViewer->viewAll();
  }
  else 
    renderToTexRoot->whichChild.setValue(SO_SWITCH_NONE);

  if (cpt->auditorID.getValue() == "animation") {
    if (iSensor->isScheduled())
      iSensor->unschedule();
    else
      iSensor->schedule();
  }
} 


void 
auditorClass::dialogPushButton(SoDialogPushButton* cpt)
{
  if (cpt->auditorID.getValue() == "trigger") {
    SoDialogComboBox* cpt2 = (SoDialogComboBox*)
      topLevelDialog0->searchForAuditorId(SbString("updatePolicy"));   

    SoDialogComboBox*   cpt1 = (SoDialogComboBox*) topLevelDialog0->searchForAuditorId(SbString("shape"));

    if (cpt2->selectedItem.getValue() == 2) {
      if (cpt1->selectedItem.getValue() == 0)
        renderToTexProperty->trigger.touch();
      else
        renderToTexProperty2->trigger.touch();
    }
  }
}


void 
auditorClass::dialogComboBox(SoDialogComboBox* cpt)
{
  mainViewer->bindNormalContext();

  SoDialogRealSlider* cpt2 = (SoDialogRealSlider*) topLevelDialog0->searchForAuditorId(SbString("exposure"));
  if (cpt->auditorID.getValue() == "updatePolicy") {
    SoDialogComboBox*   cpt0 = (SoDialogComboBox*) topLevelDialog0->searchForAuditorId(SbString("shape"));
    switch (cpt->selectedItem.getValue()) {  
    case 0 : //Each frame
      {
        if (cpt0->selectedItem.getValue() == 0)
          renderToTexProperty->updatePolicy  = SoRenderToTextureProperty::WHEN_NEEDED;
        else
          renderToTexProperty2->updatePolicy = SoRenderToTextureProperty::WHEN_NEEDED;
      }
      break;
    case 1 : //When needed
      {
        if (cpt0->selectedItem.getValue() == 0)
          renderToTexProperty->updatePolicy  = SoRenderToTextureProperty::EACH_FRAME;
        else
          renderToTexProperty2->updatePolicy = SoRenderToTextureProperty::EACH_FRAME;
      }
      break;
    case 2 : //On trigger
      {
        if (cpt0->selectedItem.getValue() == 0)
          renderToTexProperty->updatePolicy  = SoRenderToTextureProperty::ON_TRIGGER;
        else
          renderToTexProperty2->updatePolicy = SoRenderToTextureProperty::ON_TRIGGER;
      }
      break;
    }
  }
  else if (cpt->auditorID.getValue() == "component") {
    SoDialogComboBox*   cpt0 = (SoDialogComboBox*) topLevelDialog0->searchForAuditorId(SbString("shape"));
    switch (cpt->selectedItem.getValue()) {  
    case 0 : //RGB
      {
        if (cpt0->selectedItem.getValue() == 0)
          renderToTexProperty->component  = SoRenderToTextureProperty::RGB;  
        else
          renderToTexProperty2->component = SoRenderToTextureProperty::RGB;  
      }
      break;
    case 1 : //RGB_TRANSPARENCY
      {
        if (cpt0->selectedItem.getValue() == 0)
          renderToTexProperty->component  = SoRenderToTextureProperty::RGB_TRANSPARENCY;  
        else
          renderToTexProperty2->component = SoRenderToTextureProperty::RGB_TRANSPARENCY;  
      }
      break;
    case 2 : //DEPTH
      {
        if (cpt0->selectedItem.getValue() == 0)
          renderToTexProperty->component  = SoRenderToTextureProperty::DEPTH;
        else
          renderToTexProperty2->component = SoRenderToTextureProperty::DEPTH;
      }
      break;
    }
  }
  else if (cpt->auditorID.getValue() == "shape") {
    SoDialogCheckBox*   cpt1 = (SoDialogCheckBox*) topLevelDialog0->searchForAuditorId(SbString("display"));
    SoDialogCheckBox*   cpt3 = (SoDialogCheckBox*) topLevelDialog0->searchForAuditorId(SbString("animation"));
    SoDialogComboBox*   cpt4 = (SoDialogComboBox*) topLevelDialog0->searchForAuditorId(SbString("source"));
    SoDialogIntegerSlider* cpt5 = (SoDialogIntegerSlider*) topLevelDialog0->searchForAuditorId(SbString("size"));
    SoDialogCheckBox*   cpt6 = (SoDialogCheckBox*) topLevelDialog0->searchForAuditorId(SbString("mipmap"));
    SoDialogComboBox*   cpt7 = (SoDialogComboBox*) topLevelDialog0->searchForAuditorId(SbString("component"));
    SoDialogComboBox*   cpt8 = (SoDialogComboBox*) topLevelDialog0->searchForAuditorId(SbString("updatePolicy"));

    if (cpt1->state.getValue() == TRUE) {
      if (cpt->selectedItem.getValue() != selectedShape) {
        switch (cpt->selectedItem.getValue()) {  
        case 0 : //TEXTURE2D
          {
            cpt2->enable.setValue(FALSE);
            cpt3->enable.setValue(TRUE);
            cpt4->removeItem(3);
            cpt4->removeItem(2);
            cpt4->selectedItem = 0;          
            cpt4->selectedItem.setValue(0);
            renderToTexProperty->size.setValue(512, 512);
            cpt5->value.setValue(512);
            cpt6->state.setValue(FALSE);
            renderToTexProperty->component = SoRenderToTextureProperty::RGB;
            cpt7->selectedItem.setValue(0);
            tex2D->renderToTextureProperty.setValue(renderToTexProperty);
            cpt8->selectedItem.setValue(0);
            renderToTexRoot->whichChild.setValue(0);
            renderToTexProperty->updatePolicy = SoRenderToTextureProperty::WHEN_NEEDED;
            renderToTexProperty2->updatePolicy = SoRenderToTextureProperty::WHEN_NEEDED;
            selectedShape = 0;
          }
          break;
        case 1 : //CUBEMAP
          {
            cpt3->state.setValue(FALSE);
            iSensor->unschedule();
            cpt2->enable.setValue(FALSE);
            cpt3->enable.setValue(FALSE);
            cpt4->addItem("HDRI Horizontal Cross");
            cpt4->addItem("HDRI Vertical Cross");
            cpt4->selectedItem = 0;         
            cpt4->selectedItem.setValue(0);
            renderToTexProperty2->size.setValue(512, 512);
            cpt5->value.setValue(512);
            cpt6->state.setValue(FALSE);
            renderToTexProperty2->component = SoRenderToTextureProperty::RGB;
            cpt7->selectedItem.setValue(0);
            texCubemap->renderToTextureProperty.setValue(renderToTexProperty2);
            cpt8->selectedItem.setValue(0);
            renderToTexProperty->updatePolicy = SoRenderToTextureProperty::WHEN_NEEDED;
            renderToTexProperty2->updatePolicy = SoRenderToTextureProperty::WHEN_NEEDED;
            renderToTexRoot->whichChild.setValue(1);
            selectedShape = 1;
          }
          break;
        }
      }
      renderToTexViewer->viewAll();
    }
    else 
      renderToTexRoot->whichChild.setValue(SO_SWITCH_NONE);
  }
  else if (cpt->auditorID.getValue() == "source") {
    SoDialogComboBox* cpt0 = (SoDialogComboBox*) topLevelDialog0->searchForAuditorId(SbString("shape"));
    switch (cpt->selectedItem.getValue()) {  
    case 0 : //PBUFFER
      {
        cpt2->enable.setValue(FALSE);
        if (cpt0->selectedItem.getValue() == 0)
          tex2D->renderToTextureProperty.setValue(renderToTexProperty);
        else
          texCubemap->renderToTextureProperty.setValue(renderToTexProperty2);
      }
      break;
    case 1 : //RASTER
      {
        cpt2->enable.setValue(FALSE);
        if (cpt0->selectedItem.getValue() == 0) {
          tex2D->renderToTextureProperty.setValue(NULL);
        }
        else {
          
          SbString faceFileDir= SbFileHelper::expandString("$OIVHOME/examples/source/Inventor/Features/RenderToTexture/");
   
          texCubemap->renderToTextureProperty.setValue(NULL);
          const char *faceFile[6] = {
          "xplus.jpg",
          "yplus.jpg",
          "zplus.jpg",
          "xminus.jpg",
          "yminus.jpg",
          "zminus.jpg"
          };
          for (int i=0;i<6;i++){
            texCubemap->filenames.set1Value(i,SbString(faceFileDir + SbString(faceFile[i])));
          }
        }
      }
      break;
    case 2 : //HDRI HC
      {                   
        cpt2->enable.setValue(TRUE);

        texCubemap->renderToTextureProperty.setValue(NULL);
        texCubemap->filenames.set1Value(0, SbFileHelper::expandString("$OIVHOME/examples/source/Inventor/Features/RenderToTexture/DH201HClite.hdr"));
      }
      break;
    case 3 : //HDRI VC
      {
        cpt2->enable.setValue(TRUE);

        texCubemap->renderToTextureProperty.setValue(NULL);
        texCubemap->filenames.set1Value(0, SbFileHelper::expandString("$OIVHOME/examples/source/Inventor/Features/RenderToTexture/stpeters_crossVC.hdr"));
      }
      break;
    }
  }

  mainViewer->unbindNormalContext();

  renderToTexViewer->viewAll();
}


void 
auditorClass::menuFileSelection(SoMenuFileSelection* cpt)
{
  SbString filePath = cpt->fileDirectory.getValue();
  filePath += SbString("/");
  filePath += cpt->filename.getValue();

  if (cpt->auditorID.getValue() == "openIV") {
    SoInput myInput;
    if (! myInput.openFile(filePath.getString())) return;
    mainSep = SoDB::readAll(&myInput);
    if (!mainSep) return;

    mainRoot->removeAllChildren();
    mainRoot->addChild(mainSep);
    mainViewer->viewAll();
  }
  else if (cpt->auditorID.getValue() == "writeIV") {
    FILE *myFile = fopen(filePath.getString(), "w");	

    SoWriteAction *myWriteAction = new SoWriteAction;
    SoOutput *myOut = myWriteAction->getOutput();
    myOut->setFilePointer(myFile);

    myWriteAction->apply(renderToTexRoot);
    fclose(myFile);

  }

}

Widget
buildInterface(Widget window)
{
  topLevelDialog0 = (SoTopLevelDialog*) SoDialogViz::loadFromFile(SbFileHelper::expandString("$OIVHOME/examples/source/Inventor/Features/RenderToTexture/RenderToTextureDialog.iv"));

  if (topLevelDialog0) { 
    topLevelDialog0->buildDialog( window, TRUE );
    auditorClass* auditor0 = new auditorClass;
    topLevelDialog0->addAuditor(auditor0);
    customNode0 = (SoDialogCustom*)topLevelDialog0->searchForAuditorId(SbString("viewer0"));
    topLevelDialog0->label.setValue("RenderToTextureDemo");
    topLevelDialog0->show();  

    customNode1 = (SoDialogCustom*)topLevelDialog0->searchForAuditorId(SbString("viewer1"));
  }

  return customNode0 ? customNode0->getWidget() : window;
}

void 
fpsCallback(float fps, void*, SoXtViewer* viewer)
{
  char numTriangles[10]; 
  char frameTime[50];

  sprintf(frameTime, "%.1f fps", fps);

  SoGLRenderAction *glAction = viewer->getGLRenderAction();
  countAction->setDecimationValue(glAction->getDecimationType(), 
    glAction->getDecimationPercentage() );

  if (viewer->getSceneGraph()) {
    countAction->apply(viewer->getSceneGraph());
    sprintf(numTriangles, "%d", countAction->getTriangleCount());
  }
  else
    sprintf(numTriangles, "0");

  SbString text;

  text = SbString(numTriangles);
  text += SbString(" Triangles - ") ;
  text += SbString(frameTime);

  topLevelDialog0->label.setValue(text.getString());
}


