/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2020 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/

#include <Inventor/Win/SoWinResource.h>
#include "SoWinExaminerViewerSetKeyBinding.h"

// This part is use to create your own key and mouse binding for your Examiner viewer.
SoWinExaminerViewerSetKeyBinding::SoWinExaminerViewerSetKeyBinding(
  Widget parent,
  const char *name, 
  SbBool buildInsideParent, 
  SoWinFullViewer::BuildFlag flag, 
  SoWinViewer::Type type)
 : SoWinExaminerViewer(parent, name, buildInsideParent, flag, type)
{
  // New key binding.

  // Reverse zoom
  addFunctionKeyBinding(SoKeyboardEvent::F2, new SoViewingReverseDolly());
  printf("Press F2 for Reverse Dolly viewing\n");
  // Zoom
  addFunctionKeyBinding(SoKeyboardEvent::F3, new SoViewingDolly());
  printf("Press F3 for Dolly viewing\n");
  // Translation
  addFunctionKeyBinding(SoKeyboardEvent::F4, new SoViewingTranslation());
  printf("Press F4 for Translation viewing\n");
  // X Rotation
  addFunctionKeyBinding(SoKeyboardEvent::F5, new SoViewingRotationX());
  printf("Press F5 for RotationX viewing\n");
  // Y Rotation
  addFunctionKeyBinding(SoKeyboardEvent::F6, new SoViewingRotationY());
  printf("Press F6 for RotationY viewing\n");
  // Z Rotation
  addFunctionKeyBinding(SoKeyboardEvent::F7, new SoViewingRotationZ());
  printf("Press F7 for RotationZ viewing\n");
  // Spherical rotation
  addFunctionKeyBinding(SoKeyboardEvent::F9, new SoViewingSphericalRotation());
  printf("Press F9 for Spherical Rotation viewing\n");
  

  // Assign new mouse binding.
  // Equivalent to F3 -> Zoom.
  SoKeyboardEvent::Key *spinModifierKeys = new SoKeyboardEvent::Key[2];
  spinModifierKeys[0]=SoKeyboardEvent::LEFT_CONTROL;
  spinModifierKeys[1]=SoKeyboardEvent::LEFT_SHIFT;
  SoMouseButtonEvent::Button *newButton = new SoMouseButtonEvent::Button[1];
  newButton[0] = SoMouseButtonEvent::BUTTON1;
  addViewingMouseBinding(spinModifierKeys, 2,newButton, 1, new SoViewingDolly());
  printf("Press LEFT_CONTROL + LEFT_SHIFT + Btn1 for Dolly viewing\n");
  
  // Equivalent to F4 -> Translation.
  SoKeyboardEvent::Key *panModifierKeys = new SoKeyboardEvent::Key[1];
  panModifierKeys[0]=SoKeyboardEvent::LEFT_SHIFT;
  SoMouseButtonEvent::Button *panButton = new SoMouseButtonEvent::Button[1];
  panButton[0] = SoMouseButtonEvent::BUTTON1;
  addViewingMouseBinding(panModifierKeys, 1, panButton, 1, new SoViewingTranslation());
  printf("Press LEFT_SHIFT + Btn1 for Translation viewing\n");
  
  // Equivalent to F2
  SoKeyboardEvent::Key *reverseDollyModifierKeys = new SoKeyboardEvent::Key[1];
  reverseDollyModifierKeys[0]=SoKeyboardEvent::LEFT_SHIFT;
  SoMouseButtonEvent::Button *reverseDollyButton = new SoMouseButtonEvent::Button[1];
  reverseDollyButton[0] = SoMouseButtonEvent::BUTTON2;
  addViewingMouseBinding(reverseDollyModifierKeys, 1, reverseDollyButton, 1, new SoViewingReverseDolly());
  printf("Press LEFT_SHIFT + Btn2 for reverse Dolly viewing\n");

  // Pick Mode
  setViewing(FALSE);
}

