/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2020 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/

#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>

#include <Inventor/SoInput.h>
#include <Inventor/nodes/SoSeparator.h>

int
main( int /*argc*/, char** argv )
{
  SoWidget window = SoXt::init( argv[0] );

  if ( window == NULL )
    exit( EXIT_FAILURE );

  SoInput* input = new SoInput;
  input->openFile( "$OIVHOME/examples/source/Inventor/Features/Shaders/SimplePassthrough/SimplePassthrough.iv" );
  SoRef<SoSeparator> root = SoDB::readAll( input );
  delete input;

  // Setup viewer
  SoXtExaminerViewer* viewer = new SoXtExaminerViewer( window );
  SoXt::setWidgetSize( window, SbVec2s(1024, 768) );
  viewer->setTitle( "Simple Passthrough Shader Example" );
  viewer->setBorder( FALSE );
  viewer->setDecoration( FALSE );
  viewer->setSceneGraph( root.ptr() );
  viewer->viewAll();
  viewer->show();

  SoXt::show( window ); // Display main window
  SoXt::mainLoop();     // Inventor event loop

  delete viewer;

  root = NULL;

  SoXt::finish();

  return EXIT_SUCCESS;
}
