//!oiv_include <Inventor/oivShaderState.h>
//!oiv_include <Inventor/oivShaderVariables.h>

layout(triangles, equal_spacing, cw) in;

void main()
{
  // Compute position
  vec4 p0 = gl_TessCoord.x * gl_in[0].gl_Position;
  vec4 p1 = gl_TessCoord.y * gl_in[1].gl_Position;
  vec4 p2 = gl_TessCoord.z * gl_in[2].gl_Position;
  vec4 position = p0 + p1 + p2;

  // Compute front color
  vec4 fc0 = gl_TessCoord.x * OivFrontColor(0);
  vec4 fc1 = gl_TessCoord.y * OivFrontColor(1);
  vec4 fc2 = gl_TessCoord.z * OivFrontColor(2);
  vec4 frontColor = fc0 + fc1 + fc2;

  // Compute tex coord
  vec4 tc0 = gl_TessCoord.x * OivTexCoord(0, 0);
  vec4 tc1 = gl_TessCoord.y * OivTexCoord(1, 0);
  vec4 tc2 = gl_TessCoord.z * OivTexCoord(2, 0);
  vec4 texCoord = tc0 + tc1 + tc2;

  OivSetFrontColor(frontColor);
  OivSetTexCoord(0, texCoord);
  gl_Position = OivModelViewProjectionMatrix() * position;
}
