//!oiv_include <Inventor/oivShaderVariables.h>

layout(triangles) in;
layout(triangle_strip, max_vertices = 3) out;
in vec4 tePosition[3];
out vec3 gFacetNormal;

void main()
{
  vec3 A = tePosition[2].xyz - tePosition[0].xyz;
  vec3 B = tePosition[1].xyz - tePosition[0].xyz;
  vec3 facetNormal = normalize(cross(A, B));

  gFacetNormal = facetNormal;
  OivSetupVertex(0);
  gl_Position = tePosition[0];
  EmitVertex();

  gFacetNormal = facetNormal;
  OivSetupVertex(1);
  gl_Position = tePosition[1];
  EmitVertex();

  gFacetNormal = facetNormal;
  OivSetupVertex(2);
  gl_Position = tePosition[2];
  EmitVertex();

  EndPrimitive();
}
