//!oiv_include <Inventor/oivShaderState.h>
//!oiv_include <Inventor/oivShaderVariables.h>

layout(triangles, equal_spacing, cw) in;
in vec4 tcPosition[];
out vec4 tePosition;
out vec3 tePatchDistance;

void main()
{
  OivSetupVertex(0);

  vec3 p0 = gl_TessCoord.x * tcPosition[0].xyz;
  vec3 p1 = gl_TessCoord.y * tcPosition[1].xyz;
  vec3 p2 = gl_TessCoord.z * tcPosition[2].xyz;

  //normalize to push the new verts onto the sphere's surface
  tePosition = OivModelViewProjectionMatrix() * vec4(normalize(p0 + p1 + p2), 1);
}
