//!oiv_include <Inventor/oivShapeAttribute.h>
//!oiv_include <Inventor/oivShaderState.h>

/* !!GLSL */
void OivSetupShadowVertex();

out vec4 eposition;
out vec3 normal;
out vec3 diffuseColor;
out vec3 specularColor;
out vec3 emissiveColor;
out vec3 ambientColor;
out float shininess;

void main()
{
  // Position in clip space
  gl_Position = OivModelViewProjectionMatrix() * OivVertexPosition();

  // Position in eye space
  eposition = OivModelViewMatrix() * OivVertexPosition();

  // Normal in eye space
  normal = OivNormalMatrix() * OivVertexNormal();

  // Retrieves diffuse, specular, emissive, and ambient color from the OpenGL state.
  diffuseColor  = vec3(OivFrontMaterialDiffuse());
  specularColor = vec3(OivFrontMaterialSpecular());
  emissiveColor = vec3(OivFrontMaterialEmissive());
  ambientColor  = vec3(OivFrontMaterialAmbient());
  shininess     = OivFrontMaterialShininess();

  //Needed for shadowing
  OivSetupShadowVertex();
}
