#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/Xt/SoXtMaterialEditor.h>

#include <Inventor/nodes/SoShadowGroup.h>
#include <Inventor/nodes/SoMaterial.h>
#include <Inventor/nodes/SoCube.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoSphere.h>
#include <Inventor/nodes/SoTranslation.h>
#include <Inventor/nodes/SoComplexity.h>
#include <Inventor/nodes/SoTransform.h>
#include <Inventor/nodes/SoVertexShader.h>
#include <Inventor/nodes/SoFragmentShader.h>
#include <Inventor/nodes/SoShaderProgram.h>
#include <Inventor/nodes/SoShaderParameter.h>
#include <Inventor/nodes/SoLightModel.h>

#include <Inventor/sensors/SoNodeSensor.h>
#include <DialogViz/SoDialogVizAll.h>
#include <Inventor/helpers/SbFileHelper.h>

int
main(int, char **argv)
{
  // Initialize Inventor and Xt
  Widget MyWindow = SoXt::init(argv[0]);
  SoDialogViz::init();

  SoSeparator *root = new SoSeparator;
  root->ref();

  SoComplexity *complexity = new SoComplexity;
  complexity->value = 1.0f;

  // Create a separator for the shaders
  SoSeparator* ShaderSep = new SoSeparator;

  // Initialize and set the shader program
  SoShaderProgram *shaderProgram = new SoShaderProgram;
  shaderProgram->setVertexShader(0, SbFileHelper::expandString("$OIVHOME/examples/source/Inventor/Features/Shaders/shadowShader/PixelLightingVtx.glsl"));
  shaderProgram->setFragmentShader(1, SbFileHelper::expandString("$OIVHOME/examples/source/Inventor/Features/Shaders/shadowShader/PixelLightingFrag.glsl"));
  //The shader will be used during the shadowmap and the lighting pass
  shaderProgram->shadowShader = TRUE;

  // Add the shader program to the separator
  ShaderSep->addChild(shaderProgram);

  // Create a separator for the sphere
  SoSeparator *sphereSep = new SoSeparator;
  sphereSep->addChild(new SoSphere);

  // Add the sphere to the shaders' separator to apply the shaders to it.
  ShaderSep->addChild(sphereSep);

  // Create a cube
  SoSeparator *cubeSep = new SoSeparator;
  SoCube* cube = new SoCube;
  cube->width = 2;
  cube->height = 2;

  SoTranslation *cubeTrans = new SoTranslation;
  cubeTrans->translation.setValue(2.5f, 0.0f, 0.0f);
  cubeSep->addChild(cubeTrans);
  cubeSep->addChild(cube);

  // Material applied to the model
  SoMaterial *mat = new SoMaterial;
  mat->ambientColor.setValue(0.2f, 0.2f, 0.2f);
  mat->diffuseColor.setValue(0.3f, 0.3f, 0.9f);
  mat->specularColor.setValue(0.6f, 0.6f, 0.8f);
  mat->emissiveColor.setValue(0.0f, 0.0f, 0.0f);
  mat->shininess.setValue(0.2f);

  // Light model applied in the scene
  SoLightModel* lightModel = new SoLightModel;
  lightModel->model.setValue(SoLightModel::PER_VERTEX_PHONG);

  SoShadowGroup* sg = new SoShadowGroup;
  sg->method = SoShadowGroup::VARIANCE_SHADOW_MAP;
  root->addChild(sg);

  // Build the scene graph
  sg->addChild(mat);
  sg->addChild(lightModel);
  sg->addChild(complexity);
  sg->addChild(cubeSep);
  sg->addChild(ShaderSep);

  // Create a viewer
  SoXtExaminerViewer* EViewer = new SoXtExaminerViewer(MyWindow);

  // Attach and show viewer
  EViewer->setSceneGraph(sg);
  EViewer->setTitle("Custom shader with shadow");
  EViewer->setSize(SbVec2s(500, 500));
  EViewer->show();

  // Loop forever
  SoXt::show(MyWindow);
  SoXt::mainLoop();

  root->unref();
  delete EViewer;
  SoDialogViz::finish();
  SoXt::finish();

  return EXIT_SUCCESS;
}/*---------------------------------------------------------------------------*/


