/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2020 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : MMH (MMM 2001)
**=======================================================================*/

// Activate red/cyan stereo from application program
//
// Notes:
//   On MS-Windows, build as a console app.

#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/Xt/viewers/SoXtViewer.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoMaterial.h>
#include <Inventor/nodes/SoCube.h>

#include <Inventor/nodes/SoEventCallback.h>
#include <Inventor/events/SoKeyboardEvent.h>

#include <Inventor/components/stereo/SoBaseStereo.h>
#include <Inventor/components/stereo/SoAnaglyphStereo.h>

/////////////////////////////////////////////////////////////

void 
toggleRedGreenStereo(SoXtViewer *pViewer)
{
  static SoAnaglyphStereo *pAnaStereo = NULL;

  if (pAnaStereo == NULL) {
    // Create anaglyph stereo implementation
    pAnaStereo = new SoAnaglyphStereo();

    // Tell it to use red/green (actually the default)
    pAnaStereo->setColorFilter(SoAnaglyphStereo::RED_CYAN);

    // Default stereo offset is a little too big...
    pViewer->setStereoOffset(1.0);
  }
  else
    pAnaStereo = (SoAnaglyphStereo*)pViewer->getStereoViewType();


  // Tell the viewer to use this stereo implementation
  if (pViewer->getStereoViewType() != pAnaStereo && pAnaStereo)
    pViewer->setStereoViewType(pAnaStereo);

  // Toggle stereo on/off
  SbBool isActive = pViewer->isStereoActive();
  pViewer->setStereoActive(!isActive);
}

/////////////////////////////////////////////////////////////

void 
EventCallback(void *userData, SoEventCallback *node)
{
  const SoEvent *event = node->getEvent();
  if (SO_KEY_PRESS_EVENT(event, R)) {
    SoXtViewer *pViewer = (SoXtViewer*)userData;
    toggleRedGreenStereo(pViewer);
  }
}

/////////////////////////////////////////////////////////////

#ifdef _WIN32
SbBool EventCB(void *userData, MSG *msg)
{
  if (msg->message == WM_KEYDOWN) {
    int key = (int)(msg->wParam);
    if (key == 'R') {
      SoXtViewer *pViewer = (SoXtViewer*)userData;
      toggleRedGreenStereo(pViewer);
      return TRUE;    // This event has been handled
    }
  }
  return FALSE;
}
#endif //_WIN32

/////////////////////////////////////////////////////////////

int
main(int /*argc*/, char **argv)
{
  // Initialize Inventor
  Widget myWindow = SoXt::init(argv[0]);

    // Create a simple scene graph
  SoSeparator *pRoot = new SoSeparator;
  pRoot->ref();
  pRoot->addChild(new SoCube);

  // Create and initialize viewer
  SoXtExaminerViewer *myViewer = new SoXtExaminerViewer(myWindow);
  myViewer->setSceneGraph(pRoot);
  myViewer->setTitle("Press R to enable/disable the Red/Cyan stereo");
  toggleRedGreenStereo(myViewer);
  myViewer->show();

    // Create and initialize event callback node for keypress events.
    // Have to do this here (instead of above) so we can pass the
    // address of the viewer to the callback function.
    //
    // Note this callback will only be called when the viewer is in
    // selection mode, not in viewing mode!
  SoEventCallback *pEvCB = new SoEventCallback;
  pEvCB->addEventCallback(SoKeyboardEvent::getClassTypeId(),
			  EventCallback, (void*)myViewer);
  pRoot->insertChild(pEvCB, 0);
#ifdef _WIN32
  // This callback does not depend on the viewer mode
  myViewer->setEventCallback(EventCB, (void*)myViewer);
#endif

  // Loop forever
  SoXt::show(myWindow);
  SoXt::mainLoop();

  pRoot->unref();
  delete myViewer;
  SoXt::finish();
  return 0;
}


