

#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoEventCallback.h>
#include <Inventor/events/SoMouseButtonEvent.h> 
#include <Inventor/nodes/SoTexture2.h>
#include <Inventor/nodes/SoCoordinate3.h>
#include <Inventor/nodes/SoFaceSet.h>
#include <Inventor/SoPickedPoint.h>
#include <Inventor/nodes/SoTextureCoordinate2.h>
#include <Inventor/nodes/SoText3.h>
#include <Inventor/nodes/SoFont.h>
#include <Inventor/nodes/SoMaterial.h>
#include <Inventor/nodes/SoTransform.h>
#include <Inventor/actions/SoWriteAction.h>
#include <Inventor/helpers/SbFileHelper.h>

#ifdef _WIN32
#include <mbctype.h>
#endif
   SoTexture2 *myTexture;
   const unsigned char * myTicTacToe;
   SoTexture2 *myOOOTex;
   const unsigned char * myOOO;
   SoTexture2 *myXXXTex;
   const unsigned char * myXXX;
   const unsigned char * subTex;
   SbVec2s oooSize, xxxSize;
   SoTexture2 *nullTexture;
   int which;
   int win[] = { -1,-1,-1,-1,-1,-1,-1,-1,-1};
   SoText3 *textO;
   SoText3 *textX;
   SoText3 *text;
   SbPList winner;
   SoTransform *trans1;
   SoTransform *trans2;
   SoSeparator *myRoot;
   SoXtExaminerViewer *myViewer;

//////////////////////////////////////////////////////////////////////
 
SbBool
findPickedPoint( SoNode *root, const SbViewportRegion &viewport, 
                 const SbVec2s &cursorPosition)
{
  SoRayPickAction myPickAction(viewport);
  SbBool finish = FALSE;
  // Set an 8-pixel wide region around the pixel
  myPickAction.setPoint(cursorPosition);
  myPickAction.setRadius(8.0);
  
  // Start a pick traversal
  myPickAction.apply(root);
  const SoPickedPoint *myPickedPoint = 
                        myPickAction.getPickedPoint();
  if (myPickedPoint == NULL) return FALSE;
  SbVec3f point = myPickedPoint->getPoint(); 
  float x,y,z;
  int cell;
  point.getValue(x,y,z);

  // Determine which of the nine cells the pick was in
  if ( y < 0.359 ) {
      if ( x > 0.641 ) cell = 3;
      else if ( x > 0.359 ) cell = 2;
      else cell = 1;
  }
  else if ( y > 0.641 ) {
      if ( x > 0.641 ) cell = 9;
      else if ( x > 0.359 ) cell = 8;
      else cell = 7; 
  }
  else {
      if ( x > 0.641 ) cell = 6;
      else if ( x > 0.359 ) cell = 5;
      else cell = 4;
  }
  if (which % 2 ) {
      subTex = myOOO;
  }
  else  {
      subTex = myXXX;
      which = 0;
  }
  switch (cell) {
      case 1:
         myTexture->image.setSubValue( oooSize, SbVec2s(24,24),
            (unsigned char *) subTex);
         win[0] = which;
         break;
      case 2:
         myTexture->image.setSubValue( oooSize, SbVec2s(96,24),
            (unsigned char *) subTex);
         win[1] = which;
          break;
      case 3:
         myTexture->image.setSubValue( oooSize, SbVec2s(168,24),
            (unsigned char *) subTex);
         win[2] = which;
          break;
      case 4:
         myTexture->image.setSubValue( oooSize, SbVec2s(24,96),
            (unsigned char *) subTex);
         win[3] = which;
         break;
      case 5:
         myTexture->image.setSubValue( oooSize, SbVec2s(96,96),
            (unsigned char *) subTex);
         win[4] = which;
         break;
      case 6:
         myTexture->image.setSubValue( oooSize, SbVec2s(168,96),
            (unsigned char *) subTex);
         win[5] = which;
         break;
      case 7:
         myTexture->image.setSubValue( oooSize, SbVec2s(24,168),
            (unsigned char *) subTex);
         win[6] = which;
         break;
      case 8:
         myTexture->image.setSubValue( oooSize, SbVec2s(96,168),
            (unsigned char *) subTex);
         win[7] = which;
         break;
      case 9:
         myTexture->image.setSubValue( oooSize, SbVec2s(168,168),
            (unsigned char *) subTex);
         win[8] = which;
         break;
  }

  // Determine if there is a winner

  for ( int i=1; i >=0; i-- ) {
      text = (SoText3 *)winner[i];
      if ( win[0] == i ) {
          if ( win[1] == i && win[2] == i ) { 
              myRoot->addChild(trans1);
              myRoot->addChild(nullTexture);
              myRoot->addChild(text);
              finish = TRUE;
              break;
          }    
          if ( win[3] == i && win[6] == i ) { 
              myRoot->addChild(trans1);
              myRoot->addChild(nullTexture);
              myRoot->addChild(text);
              finish = TRUE;
              break;
          }
          if ( win[4] == i && win[8] == i ) { 
              myRoot->addChild(trans1);
              myRoot->addChild(nullTexture);
              myRoot->addChild(text);
              finish = TRUE;
              break;
          }
      }
      if ( win[1] == i ) {
          if ( win[4] == i && win[7] == i ) { 
              myRoot->addChild(trans1);
              myRoot->addChild(nullTexture);
              myRoot->addChild(text);
              finish = TRUE;
              break;
          }
      }
      if ( win[2] == i ) {
          if ( win[5] == i && win[8] == i ) { 
              myRoot->addChild(trans1);
              myRoot->addChild(nullTexture);
              myRoot->addChild(text);
              finish = TRUE;
              break;
          }
          if ( win[4] == i && win[6] == i ) { 
              myRoot->addChild(trans1);
              myRoot->addChild(nullTexture);
              myRoot->addChild(text);
              finish = TRUE;
              break;
          }
      }
      if ( win[3] == i ) {
          if ( win[4] == i && win[5] == i ) { 
              myRoot->addChild(trans1);
              myRoot->addChild(nullTexture);
              myRoot->addChild(text);
              finish = TRUE;
              break;
          }
      }
       if ( win[6] == i ) {
          if ( win[7] == i && win[8] == i ) { 
              myRoot->addChild(trans1);
              myRoot->addChild(nullTexture);
              myRoot->addChild(text);
              finish = TRUE;
              break;
          }
      }

  }

  which++;
  if ( finish ) {
      myRoot->addChild(trans2);
      myViewer->viewAll();
      myViewer->show();
  }
  return finish;
}

// CODE FOR The Inventor Mentor ENDS HERE
///////////////////////////////////////////////////////////////

// This routine is called for every mouse button event.
void
myMousePressCB(void *userData, SoEventCallback *eventCB)
{
  SoSeparator *root = (SoSeparator *) userData;
  const SoEvent *event = eventCB->getEvent();
  
  // Check for mouse button being pressed
  if (SO_MOUSE_PRESS_EVENT(event, ANY)) {
     const SbViewportRegion &myRegion = 
                  eventCB->getAction()->getViewportRegion();
    findPickedPoint(root, myRegion,
                     event->getPosition(myRegion));
                     eventCB->setHandled();
  } 
}


int
main(int, char **argv)
{
  Widget myWindow = SoXt::init(argv[0]);
  if (myWindow == NULL)
    exit(1);
  myRoot = new SoSeparator;
  myRoot->ref();
  which = 1; 
  SoFont * myFont = new SoFont;
  myFont->size.setValue(.15f);
  SoMaterial *myMaterial = new SoMaterial;
  myMaterial->diffuseColor.setValue(1., 1., 1.);
  SoText3 *title = new SoText3;
  title->string.set1Value(0,"Play TicTacToe");
  title->justification.setValue(SoText3::CENTER);
  textO = new SoText3;
  textO->justification.setValue(SoText3::CENTER);
  textO->string.setValue("O WINS");
  textX = new SoText3;
  textX->justification.setValue(SoText3::CENTER);
  textX->string.setValue("X WINS");
  winner.append(textX);
  winner.append(textO);

  nullTexture = new SoTexture2;
  nullTexture->filename.setValue("");
  trans1 = new SoTransform;
  trans1->translation.setValue(0.5f,-.3f, 0.f);
  trans2 = new SoTransform;
  trans2->translation.setValue(-0.5f,.3f, 0.f);
  SoTransform *trans3 = new SoTransform;
  trans3->translation.setValue(0.5f,1.1f, 0.f);
  SoTransform *trans4 = new SoTransform;
  trans4->translation.setValue(-0.5f,-1.1f, 0.f);

  // Each mouse button press will place an X or an O on the grid 
  SoEventCallback *myEventCB = new SoEventCallback;
 
  myRoot->addChild(myEventCB);  
  myRoot->addChild(myMaterial);
  myRoot->addChild(myFont);
  myRoot->addChild(trans3);
  myRoot->addChild(title);
  myRoot->addChild(trans4);
  myTexture = new SoTexture2;

  myTexture->filename.setValue(SbFileHelper::expandString("$OIVHOME/examples/source/Inventor/Features/SubTextures/TicTacToe.gif"));

  myTexture->model.setValue(SoTexture2::DECAL);
  myRoot->addChild(myTexture);

  SoTextureCoordinate2 *texCoord = new SoTextureCoordinate2;

  texCoord->point.set1Value(0, SbVec2f(0.,0.));
  texCoord->point.set1Value(1, SbVec2f(1.,0.));
  texCoord->point.set1Value(2, SbVec2f(1.,1.));
  texCoord->point.set1Value(3, SbVec2f(0.,1.));
  myRoot->addChild(texCoord);
  SoCoordinate3 *myCoord = new SoCoordinate3;
  myCoord->point.set1Value(0, SbVec3f(0.,0.,0.));
  myCoord->point.set1Value(1, SbVec3f(1.,0.,0.));
  myCoord->point.set1Value(2, SbVec3f(1.,1.,0.));
  myCoord->point.set1Value(3, SbVec3f(0.,1.,0.));  

  SoFaceSet *myFace = new SoFaceSet;
  myFace->numVertices.set1Value(0, 4);
  myRoot->addChild(myCoord);
  myRoot->addChild(myFace);


  SbVec2s imgSize;
  int nc, oooNc, xxxNc;

  myTicTacToe = myTexture->image.getValue(imgSize, nc);
  myOOOTex = new SoTexture2;
  myOOOTex->filename.setValue(SbFileHelper::expandString("$OIVHOME/examples/source/Inventor/Features/SubTextures/O.jpg"));
  myOOO = myOOOTex->image.getValue(oooSize,oooNc);
  myXXXTex = new SoTexture2;
  myXXXTex->filename.setValue(SbFileHelper::expandString("$OIVHOME/examples/source/Inventor/Features/SubTextures/X.jpg"));
  myXXX = myXXXTex->image.getValue(xxxSize,xxxNc);
     
  // Set up viewer:

  myViewer = new SoXtExaminerViewer(myWindow);
  myViewer->setSceneGraph(myRoot);
  SoWriteAction myAction;
  myAction.getOutput()->openFile("./test.iv");
  myAction.apply(myRoot);
  myAction.getOutput()->closeFile();

    // Set up the event callback. We want to pass the root of the
  // entire scene graph (including the camera) as the userData,
  // so we get the scene manager's version of the scene graph
  // root.
  myEventCB->addEventCallback(SoMouseButtonEvent::getClassTypeId(),
                              myMousePressCB,
                              myViewer->getSceneManager()->getSceneGraph());

  myViewer->setTitle("Examiner Viewer");
  myViewer->setViewing(FALSE);

  myViewer->show();
  
  SoXt::show(myWindow);
  SoXt::mainLoop();

  myRoot->unref();
  delete myViewer;
  SoXt::finish();

  return 0;
}

