/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : VSG (Sep 2011)
**=======================================================================*/

#include <Inventor/nodes/SoCircularExtrusion.h>
#include <Inventor/nodes/SoMaterial.h>
#include <Inventor/nodes/SoSeparator.h>

#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/actions/SoBoxHighlightRenderAction.h>
#include <Inventor/actions/SoSearchPathAction.h>
#include <Inventor/engines/SoCompose.h>
#include <Inventor/helpers/SbFileHelper.h>
#include <Inventor/nodes/SoComplexity.h>

// forward declarations
SoSeparator* loadSceneGraph( );

// global constants
static const SbString g_absPathToDialogsRes( "$OIVHOME/examples/source/Inventor/Features/Switch/InteractiveSwitch/" );

int main ( int /*argc*/, char **argv )
{
  Widget mainWindowWidget = SoXt::init( argv[0] );
  if ( mainWindowWidget == NULL )
    exit(1);

  // Root node
  SoSeparator * root = new SoSeparator;
  root->ref();

  // Set up viewer
  SoXtExaminerViewer *myViewer = new SoXtExaminerViewer( mainWindowWidget );
  
  // Load scene graph
  SoSeparator *pScGraph = loadSceneGraph( );
  root->addChild( pScGraph );

  // Set up scene graph in viewer and show
  myViewer->setSceneGraph( root );
  myViewer->show();

  SoXt::show( mainWindowWidget );
  SoXt::mainLoop();

  delete myViewer;
  root->unref();
  SoXt::finish();
  return 0;
}

SoSeparator* 
loadSceneGraph( ) 
{
  SbString fname( SbFileHelper::expandString( g_absPathToDialogsRes + "scenegraph.iv" ) );
  SoSeparator *retVal = NULL;
  // is it a .iv file? simple test
  SbString extStr = SbFileHelper::getExtension( fname );
  if ( extStr.lower() == "iv" )
  {
    SoInput in;
    SbString sceneGraphFname = SbFileHelper::expandString( fname );
    SbBool fileOpened = in.openFile( sceneGraphFname.getString(), true );
    if( fileOpened ) 
    {
      retVal = SoDB::readAll(&in);
      in.closeFile();
    }
  }
  return retVal;
}


