/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : SGI (MMM YYYY)
**=======================================================================*/

#include <Inventor/SbViewportRegion.h>
#include <Inventor/SoPickedPoint.h>
#include <Inventor/actions/SoRayPickAction.h>
#include <Inventor/nodes/SoEventCallback.h>
#include <Inventor/nodes/SoMaterial.h>
#include <Inventor/nodes/SoMultiSwitch.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoSphere.h>
#include <Inventor/nodes/SoCube.h>
#include <Inventor/nodes/SoCone.h>
#include <Inventor/nodes/SoCylinder.h>
#include <Inventor/nodes/SoTranslation.h>
#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>

#include <DialogViz/SoDialogVizAll.h>

SoMultiSwitch* myMultiSwitch1 = 0;
SoMultiSwitch* myMultiSwitch2 = 0;
SoMultiSwitch* myMultiSwitch3 = 0;
SoTopLevelDialog *myTopLevelDialog = 0;
SoXtExaminerViewer *myViewer = 0;

class GlobalAuditor : public SoDialogAuditor
{
  virtual void dialogCheckBox( SoDialogCheckBox* /*cpt*/ )
  {
    int myMultiSwitch1NumChildren = 0;
    int myMultiSwitch2NumChildren = 0;
    int myMultiSwitch3NumChildren = 0;
    myMultiSwitch1->whichChildren.deleteValues(0);
    myMultiSwitch2->whichChildren.deleteValues(0);
    myMultiSwitch3->whichChildren.deleteValues(0);
    SoDialogCheckBox* checkbox[18];
    for ( int i = 0; i < 18; i++ )
      checkbox[i] = (SoDialogCheckBox*)myTopLevelDialog->searchForAuditorId( SbString().setNum(i) );

    for ( int i = 0; i < 6; i++ )
    {
      if (checkbox[i]->state.getValue() == TRUE)
        myMultiSwitch1->whichChildren.set1Value( myMultiSwitch1NumChildren++, i );
    }

    for ( int i = 0; i < 6; i++ )
    {
      if (checkbox[i + 6]->state.getValue() == TRUE)
        myMultiSwitch2->whichChildren.set1Value( myMultiSwitch2NumChildren++, i );
    }

    for ( int i = 0; i < 6; i++ )
    {
      if (checkbox[i + 12]->state.getValue() == TRUE)
        myMultiSwitch3->whichChildren.set1Value( myMultiSwitch3NumChildren++, i );
    }

    myViewer->viewAll();
  }

  virtual void dialogComboBox( SoDialogComboBox* cpt )
  {
    if (cpt->auditorID.getValue() == "MS1_TM" )
    {
      if (((SoDialogComboBox*)cpt)->selectedItem.getValue() == 0)
        myMultiSwitch1->traversalMode.setValue( SoMultiSwitch::NONE );
      else if (((SoDialogComboBox*)cpt)->selectedItem.getValue() == 1)
        myMultiSwitch1->traversalMode.setValue( SoMultiSwitch::ALL );
      else if (((SoDialogComboBox*)cpt)->selectedItem.getValue() == 2)
        myMultiSwitch1->traversalMode.setValue( SoMultiSwitch::INCLUDE );
      else if (((SoDialogComboBox*)cpt)->selectedItem.getValue() == 3)
        myMultiSwitch1->traversalMode.setValue( SoMultiSwitch::EXCLUDE );
    }
    else if (cpt->auditorID.getValue() == "MS2_TM" )
    {
      if (((SoDialogComboBox*)cpt)->selectedItem.getValue() == 0)
        myMultiSwitch2->traversalMode.setValue( SoMultiSwitch::NONE );
      else if (((SoDialogComboBox*)cpt)->selectedItem.getValue() == 1)
        myMultiSwitch2->traversalMode.setValue( SoMultiSwitch::ALL );
      else if (((SoDialogComboBox*)cpt)->selectedItem.getValue() == 2)
        myMultiSwitch2->traversalMode.setValue( SoMultiSwitch::INCLUDE );
      else if (((SoDialogComboBox*)cpt)->selectedItem.getValue() == 3)
        myMultiSwitch2->traversalMode.setValue( SoMultiSwitch::EXCLUDE );
    }
    else if (cpt->auditorID.getValue() == "MS3_TM" )
    {
      if (((SoDialogComboBox*)cpt)->selectedItem.getValue() == 0)
        myMultiSwitch3->traversalMode.setValue( SoMultiSwitch::NONE );
      else if (((SoDialogComboBox*)cpt)->selectedItem.getValue() == 1)
        myMultiSwitch3->traversalMode.setValue( SoMultiSwitch::ALL );
      else if (((SoDialogComboBox*)cpt)->selectedItem.getValue() == 2)
        myMultiSwitch3->traversalMode.setValue( SoMultiSwitch::INCLUDE );
      else if (((SoDialogComboBox*)cpt)->selectedItem.getValue() == 3)
        myMultiSwitch3->traversalMode.setValue( SoMultiSwitch::EXCLUDE );
    }
    else if (cpt->auditorID.getValue() == "MS3_IM" )
    {
      if (((SoDialogComboBox*)cpt)->selectedItem.getValue() == 0)
        myMultiSwitch3->inheritMode.setValue( SoMultiSwitch::NO );
      else if (((SoDialogComboBox*)cpt)->selectedItem.getValue() == 1)
        myMultiSwitch3->inheritMode.setValue( SoMultiSwitch::MODE );
      else if (((SoDialogComboBox*)cpt)->selectedItem.getValue() == 2)
        myMultiSwitch3->inheritMode.setValue( SoMultiSwitch::LIST );
      else if (((SoDialogComboBox*)cpt)->selectedItem.getValue() == 3)
        myMultiSwitch3->inheritMode.setValue( SoMultiSwitch::ANY );
    }
    myViewer->viewAll();
  }
};

int
main(int, char **argv)
{
  Widget myWindow = SoXt::init(argv[0]); 
  if (myWindow == NULL)
    exit(1);
  SoDialogViz::init();

  SoSeparator *root = new SoSeparator;
  root->ref();
  
  myMultiSwitch1 = new SoMultiSwitch();
  myMultiSwitch2 = new SoMultiSwitch();
  myMultiSwitch3 = new SoMultiSwitch();

  SoTranslation *myTranslation = new SoTranslation;
  myTranslation->translation.setValue(4.0f, 0.0f, 0.0f);
  SoMaterial* redMaterial = new SoMaterial();
  redMaterial->diffuseColor.setValue( 1, 0, 0 );
  SoMaterial* blueMaterial = new SoMaterial();
  blueMaterial->diffuseColor.setValue( 0, 0, 1 );

  root->addChild(myMultiSwitch1);
    myMultiSwitch1->addChild(myTranslation);
    myMultiSwitch1->addChild(new SoCone);
    myMultiSwitch1->addChild(myMultiSwitch3);
  root->addChild(myMultiSwitch2);
    myMultiSwitch2->addChild(myMultiSwitch3);
    myMultiSwitch2->addChild(myTranslation);
    myMultiSwitch2->addChild(new SoCylinder);

    myMultiSwitch3->addChild(redMaterial);
    myMultiSwitch3->addChild(blueMaterial);
    myMultiSwitch3->addChild(myTranslation);
    myMultiSwitch3->addChild(new SoCube);
    myMultiSwitch3->addChild(myTranslation);
    myMultiSwitch3->addChild(new SoSphere);

  // Create a render area in which to see our scene graph.
  myViewer = new SoXtExaminerViewer(myWindow);
  
  // Turn off viewing to allow picking
  myViewer->setViewing(FALSE);
  
  myViewer->setSceneGraph(root);
  myViewer->setTitle("MultiSwitch demo");
  myViewer->show();
  
  myTopLevelDialog = (SoTopLevelDialog *)SoDialogViz::loadFromFile("$OIVHOME/examples/source/Inventor/Features/Switch/MultiSwitch/dialog.iv");
  myTopLevelDialog->addAuditor( new GlobalAuditor );
  myTopLevelDialog->buildDialog( myWindow, FALSE);
  myTopLevelDialog->show();

  SoXt::show(myWindow);  
  SoXt::mainLoop();

  root->unref();
  delete myViewer;
  myTopLevelDialog->close();
  SoDialogViz::finish();
  SoXt::finish();

  return 0;
}



