/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : SGI (MMM YYYY)
**=======================================================================*/

#include <Inventor/SbViewportRegion.h>
#include <Inventor/SoPickedPoint.h>
#include <Inventor/actions/SoRayPickAction.h>
#include <Inventor/nodes/SoEventCallback.h>
#include <Inventor/nodes/SoMaterial.h>
#include <Inventor/nodes/SoPathSwitch.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoSphere.h>
#include <Inventor/nodes/SoTranslation.h>
#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>


SoPathSwitch* myPathSwitch;

SbBool
selectPickedPath(SoNode *root, 
                const SbViewportRegion &viewport, 
                const SbVec2s &cursorPosition)
{
  SoRayPickAction myPickAction(viewport);
  
  // Set an 8-pixel wide region around the pixel
  myPickAction.setPoint(cursorPosition);
  myPickAction.setRadius(8.0);
  
  // Start a pick traversal
  myPickAction.apply(root);
  const SoPickedPoint *myPickedPoint = myPickAction.getPickedPoint();
  if (myPickedPoint == NULL)
    return FALSE;
  
  // truncate the path so that the resulting path is a global path for shape.
  SoPath* myPath = myPickedPoint->getPath();
  SoNode* tailNode = myPath->getTail();
  while (!tailNode->isOfType(SoSeparator::getClassTypeId()) )
  {
    if (tailNode->getName() == "sharedScene")
      return TRUE;
    myPath->truncate(myPath->getLength() - 1);
    tailNode = myPath->getTail();
  }
  myPathSwitch->path = myPath;

  return TRUE;
}

// This routine is called for every mouse button event.
void
myMousePressCB(void *userData, SoEventCallback *eventCB)
{
  SoSeparator *root = (SoSeparator *) userData;
  const SoEvent *event = eventCB->getEvent();
  
  // Check for mouse button being pressed
  if (SO_MOUSE_PRESS_EVENT(event, ANY))
  {
    const SbViewportRegion &myRegion = eventCB->getAction()->getViewportRegion();
    selectPickedPath(root, myRegion, event->getPosition(myRegion));
    eventCB->setHandled();
  } 
}

int
main(int, char **argv)
{
  Widget myWindow = SoXt::init(argv[0]); 
  if (myWindow == NULL)
    exit(1);

  SoSeparator *root = new SoSeparator;
  root->ref();
  
  // Add an event callback to catch mouse button presses.
  // The callback is set up later on.
  SoEventCallback *myEventCB = new SoEventCallback;
  root->addChild(myEventCB);
  
  SoSeparator* sharedObjectGroup = new SoSeparator;
  sharedObjectGroup->setName("sharedScene");
  root->addChild(sharedObjectGroup);

  SoTranslation *myTranslation = new SoTranslation;
  myTranslation->translation.setValue(4.0f, 0.0f, 0.0f);
  root->addChild(myTranslation);

  myPathSwitch = new SoPathSwitch;
  sharedObjectGroup->addChild(myPathSwitch);

  SoMaterial *myMaterial = new SoMaterial;
  myMaterial->diffuseColor.setValue(1.0f, 0.0f, 0.0f);
  myMaterial->setOverride(true);
  myPathSwitch->addChild(myMaterial);

  sharedObjectGroup->addChild( new SoSphere );
  
  root->addChild(sharedObjectGroup);
  root->addChild(myTranslation);
  root->addChild(sharedObjectGroup);
  root->addChild(myTranslation);
  root->addChild(sharedObjectGroup);

  // Create a render area in which to see our scene graph.
  SoXtExaminerViewer *myViewer = new SoXtExaminerViewer(myWindow);
  
  // Turn off viewing to allow picking
  myViewer->setViewing(FALSE);
  
  myViewer->setSceneGraph(root);
  myViewer->setTitle("Pick Actions & Paths");
  myViewer->show();
  
  // Set up the event callback. We want to pass the root of the
  // entire scene graph (including the camera) as the userData,
  // so we get the scene manager's version of the scene graph
  // root.
  myEventCB->addEventCallback(SoMouseButtonEvent::getClassTypeId(),
                              myMousePressCB,
                              myViewer->getSceneManager()->getSceneGraph());
  
  SoXt::show(myWindow);  
  SoXt::mainLoop();

  root->unref();
  delete myViewer;
  SoXt::finish();

  return 0;
}



