#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>

#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoMaterial.h>
#include <Inventor/nodes/SoFont.h>
#include <Inventor/nodes/SoText3.h>

#include <Inventor/SoOutput.h>
#include <Inventor/actions/SoWriteAction.h>

#include <Inventor/SoWinApp.h>


#ifdef WIN32
#  define FROM2TO4(a,b) a, b
#else
#  define FROM2TO4(a,b) a, b, 0, 0
#endif

const unsigned char chinese[] = {
  FROM2TO4(0xA0, 0x52),
  FROM2TO4(0x1F, 0x90),
  FROM2TO4(0x65, 0x51),
  FROM2TO4(0x11, 0x62),
  FROM2TO4(0xEC, 0x4E),
  FROM2TO4(0x84, 0x76),
  FROM2TO4(0xB0, 0x65),
  FROM2TO4(0xF4, 0x7E),
  FROM2TO4(0xA6, 0x5E),
  FROM2TO4(0x02, 0x30),
  FROM2TO4(0, 0)
};

const unsigned char japanese[] = {
  FROM2TO4(0xC1, 0x79),
  FROM2TO4(0x54, 0x90),
  FROM2TO4(0x6E, 0x30),
  FROM2TO4(0xB0, 0x65),
  FROM2TO4(0x57, 0x30),
  FROM2TO4(0x44, 0x30),
  FROM2TO4(0x21, 0x6B),
  FROM2TO4(0x43, 0x51),
  FROM2TO4(0x6B, 0x30),
  FROM2TO4(0xA0, 0x52),
  FROM2TO4(0x1F, 0x90),
  FROM2TO4(0x02, 0x30),
  FROM2TO4(0, 0)
};

int
main(int /*argc*/, char **argv)
{
  // Initialize Inventor
  Widget myWindow = SoXt::init(argv[0]);

  SoSeparator *pRoot = NULL;
  SoMaterial  *pMatl = new SoMaterial;
  pMatl->diffuseColor.setValue( 1,0,0 );

  SoFont *pFont = new SoFont;
#ifdef WIN32
  pFont->name = "Arial Unicode MS";
#elif defined (__linux)
  pFont->name = "IPAMincho"; // /usr/share/fonts/ipa-mincho/ipam.ttf
#else
  pFont->name = "Kochi Mincho";
#endif
  pFont->renderStyle = SoFont::TEXTURE;
  pFont->size = 40.0;

  //// Chinese
  //SbString str((wchar_t*)chinese);

  // Japanese
  SbString str ("Accelerating into our new dimensions.");
  SbString strU ( (wchar_t*)japanese );

  SoText3 *pText = new SoText3;
  pText->parts = SoText3::ALL;
  pText->string.set1Value( 0, str );
  pText->string.set1Value( 1, strU );

  pRoot = new SoSeparator;
  pRoot->ref();
  pRoot->addChild( pMatl );
  pRoot->addChild( pFont );
  pRoot->addChild( pText );

  // Create a viewer
  SoXtExaminerViewer *myViewer =  new SoXtExaminerViewer(myWindow);
  myViewer->setBackgroundColor( SbColor(0,0.75,0.75) );
  myViewer->setSceneGraph( pRoot );
  myViewer->show();

  // Loop forever
  SoXt::show(myWindow);
  SoXt::mainLoop();

  SoOutput out;
  out.openFile("output.iv");
  SoWriteAction wa(&out);
  wa.apply(pRoot);
  out.closeFile();

  pRoot->unref();
  delete myViewer;
  SoXt::finish();

  return 0;
}


